/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.cli.impl.base;

import com.microfocus.sv.svconfigurator.cli.ICLICommandProcessor;
import com.microfocus.sv.svconfigurator.util.CliUtils;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CliCommandProcessorBase
implements ICLICommandProcessor {
    public String command;
    public Options options;
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public CliCommandProcessorBase(String command) {
        this.command = command;
        this.options = this.createCommandLineOptions();
    }

    @Override
    public final int process(String[] args) {
        BasicParser parser = new BasicParser();
        try {
            CommandLine parameters = parser.parse(this.options, args);
            return this.execute(parameters);
        }
        catch (ParseException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
            this.printHelp();
            return 1000;
        }
    }

    protected abstract int execute(CommandLine var1);

    public String getHelpUsage() {
        return this.command + " [parameters]";
    }

    public void printHelp() {
        CliUtils.printHelp(this.getHelpUsage(), this.options, this.createMandatoryCommandLineOptions());
    }

    private Options createCommandLineOptions() {
        Options result = new Options();
        this.addCommandLineOptions(result);
        return result;
    }

    private Options createMandatoryCommandLineOptions() {
        Options result = new Options();
        this.addMandatoryCommandLineOptions(result);
        return result;
    }

    protected void addCommandLineOptions(Options options) {
    }

    protected void addMandatoryCommandLineOptions(Options options) {
    }
}

