/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.cli.impl;

import com.microfocus.sv.svconfigurator.build.IProjectBuilder;
import com.microfocus.sv.svconfigurator.cli.ICLICommandProcessor;
import com.microfocus.sv.svconfigurator.cli.impl.AbstractProjectCommandProcessor;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.impl.exception.ProjectBuilderException;
import com.microfocus.sv.svconfigurator.processor.IListProjectProcessor;
import com.microfocus.sv.svconfigurator.processor.ListProjectProcessorInput;
import com.microfocus.sv.svconfigurator.util.CliUtils;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListProjectCLICommandProcessor
extends AbstractProjectCommandProcessor
implements ICLICommandProcessor {
    public static final String COMMAND = "listProject";
    private static final String MANDAT_PROP_PROJ = "project_file";
    private static final String HELP_USAGE = "listProject [parameters] <project_file>";
    private static final Logger LOG = LoggerFactory.getLogger(ListProjectCLICommandProcessor.class);
    private IListProjectProcessor processor;
    private Options opts;

    public ListProjectCLICommandProcessor(IProjectBuilder projectBuilder, IListProjectProcessor processor) {
        super(projectBuilder);
        this.processor = processor;
        this.opts = this.createPropsOptions();
    }

    @Override
    public int process(String[] args) {
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(this.opts, args);
            IProject proj = this.getProject(line);
            if (proj == null) {
                throw new ParseException("You have to specify the project.");
            }
            this.processor.process(new ListProjectProcessorInput(proj, false, CliUtils.obtainOutputFormat(line)));
        }
        catch (ParseException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            CliUtils.printHelp(HELP_USAGE, this.opts, this.createMandatParamOptions());
            return 1000;
        }
        catch (ProjectBuilderException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return 1100;
        }
        return 0;
    }

    private Options createPropsOptions() {
        Options opts = new Options();
        opts.addOption("w", "project-password", true, "Project encryption password");
        CliUtils.addOutputFormatOptions(opts);
        return opts;
    }

    private Options createMandatParamOptions() {
        Options opts = new Options();
        opts.addOption(MANDAT_PROP_PROJ, false, "Project file (.vproj or .vproja) to be listed.");
        return opts;
    }
}

