/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.cli.impl;

import com.microfocus.sv.svconfigurator.build.IProjectBuilder;
import com.microfocus.sv.svconfigurator.cli.ICLICommandProcessor;
import com.microfocus.sv.svconfigurator.cli.impl.AbstractProjectCommandProcessor;
import com.microfocus.sv.svconfigurator.core.impl.Server;
import com.microfocus.sv.svconfigurator.core.impl.exception.AbstractSVCException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import com.microfocus.sv.svconfigurator.core.server.IServerCommandRunner;
import com.microfocus.sv.svconfigurator.core.server.ServersCommandExecutor;
import com.microfocus.sv.svconfigurator.processor.HotSwapProcessorInput;
import com.microfocus.sv.svconfigurator.processor.IHotSwapProcessor;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.util.CliUtils;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HotSwapCLICommandProcessor
extends AbstractProjectCommandProcessor
implements ICLICommandProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(HotSwapCLICommandProcessor.class);
    public static final String COMMAND = "hotswap";
    private static final String PARAM_SVC_PERF_MODEL = "pm";
    private static final String LONG_PARAM_SVC_PERF_MODEL = "perf-model";
    private static final String PARAM_FORCE = "f";
    private static final String LONG_PARAM_FORCE = "force";
    private static final String MANDAT_PARAM_SVC = "service_ident";
    private static final String HELP_USAGE = String.format("%s [parameters] <%s>", "hotswap", "service_ident");
    private Options opts;
    private IHotSwapProcessor processor;

    public HotSwapCLICommandProcessor(IProjectBuilder projectBuilder, IHotSwapProcessor processor) {
        super(projectBuilder);
        this.processor = processor;
        this.opts = this.createParamOptions();
    }

    @Override
    public int process(String[] args) {
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(this.opts, args);
            List<Server> servers = CliUtils.obtainServers(line, null);
            String[] lineArgs = line.getArgs();
            if (lineArgs.length != 1) {
                throw new ParseException("Expected 1 argument(<service_identification>).");
            }
            boolean force = line.hasOption(PARAM_FORCE);
            String svcIdent = lineArgs[0];
            String perfModel = line.getOptionValue(PARAM_SVC_PERF_MODEL);
            final HotSwapProcessorInput input = new HotSwapProcessorInput(force, svcIdent, perfModel);
            ServersCommandExecutor executor = new ServersCommandExecutor(servers, this.processor.getCommandExecutorFactory());
            executor.execute(new IServerCommandRunner(){

                @Override
                public void runCommand(ICommandExecutor executor) throws AbstractSVCException {
                    HotSwapCLICommandProcessor.this.processor.process(input, executor);
                }
            });
        }
        catch (ParseException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            CliUtils.printHelp(HELP_USAGE, this.opts, this.createMandatParamOptions());
            return 1000;
        }
        catch (SVCParseException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            CliUtils.printHelp(HELP_USAGE, this.opts, this.createMandatParamOptions());
            return 1000;
        }
        catch (CommunicatorException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return 1200;
        }
        catch (CommandExecutorException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return 1300;
        }
        catch (IllegalArgumentException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return 1000;
        }
        catch (AbstractSVCException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return 1500;
        }
        return 0;
    }

    private Options createParamOptions() {
        Options opts = new Options();
        CliUtils.addConnectionOptions(opts);
        opts.addOption(PARAM_FORCE, LONG_PARAM_FORCE, false, "Force mode (if the service is locked, it will unlock it)");
        opts.addOption(PARAM_SVC_PERF_MODEL, LONG_PARAM_SVC_PERF_MODEL, true, "Performance model identification (id or name)");
        return opts;
    }

    private Options createMandatParamOptions() {
        Options opts = new Options();
        opts.addOption(MANDAT_PARAM_SVC, false, "Identification of the service (ID or the name) whose performance model we want to change. There can be more services with the same name in the server. In this case you will be asked to use the ID of the service.");
        return opts;
    }
}

