/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.build;

import com.microfocus.sv.svconfigurator.core.ILoggedServiceCallList;
import com.microfocus.sv.svconfigurator.core.IManifest;
import com.microfocus.sv.svconfigurator.core.IProjectElement;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.exception.ProjectBuilderException;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ManifestProcessor {
    private static final String FIND_CHILDREN_BY_ID = "//*[local-name()='Item' and ./@id='%s']//*[local-name()='Ref']/@id";
    private static final String FIND_ROOT_ID = "/*[local-name() = 'deploymentManifest']/@rootItemId";
    private Map<String, IProjectElement> elementMap;
    private IManifest manifest;
    private Document doc;
    private XPath xpath;

    public ManifestProcessor(Map<String, IProjectElement> elementMap, IManifest manifest) throws ProjectBuilderException {
        this.elementMap = elementMap;
        this.manifest = manifest;
        XPathFactory factory = XPathFactory.newInstance();
        this.xpath = factory.newXPath();
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            docFactory.setNamespaceAware(true);
            DocumentBuilder builder = docFactory.newDocumentBuilder();
            this.doc = builder.parse(this.manifest.getData());
        }
        catch (IOException ex) {
            throw new ProjectBuilderException("Error during Manifest data read", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new ProjectBuilderException("Error during Manifest data read", ex);
        }
        catch (SAXException ex) {
            throw new ProjectBuilderException("Error during Manifest data read", ex);
        }
        catch (SVCParseException ex) {
            throw new ProjectBuilderException("Error during Manifest data read", ex);
        }
    }

    public IService getRoot() throws ProjectBuilderException {
        try {
            String rootId = this.xpath.evaluate(FIND_ROOT_ID, this.doc);
            IProjectElement root = this.elementMap.get(rootId);
            if (root == null) {
                throw new ProjectBuilderException("Root element (specified in the manifest) with ID '" + rootId + "' was not found in the project archive.");
            }
            return (IService)root;
        }
        catch (XPathExpressionException ex) {
            throw new ProjectBuilderException("Error during xpath evaluation.", ex);
        }
    }

    public Collection<IProjectElement> getChildrenForElement(IProjectElement el) throws ProjectBuilderException {
        try {
            String id = el.getId();
            NodeList nodes = (NodeList)this.xpath.evaluate(String.format(FIND_CHILDREN_BY_ID, id), this.doc, XPathConstants.NODESET);
            HashSet<IProjectElement> res = new HashSet<IProjectElement>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                String nodeId = nodes.item(i).getNodeValue();
                IProjectElement child = this.elementMap.get(nodeId);
                if (child == null) {
                    throw new ProjectBuilderException("Element (specified in the manifest '" + this.manifest.getId() + "') with ID '" + nodeId + "' was not found in the project archive.");
                }
                res.add(child);
            }
            if (el instanceof IService) {
                for (Map.Entry<String, IProjectElement> entry : this.elementMap.entrySet()) {
                    ILoggedServiceCallList loggedServiceCallList;
                    IProjectElement value = entry.getValue();
                    if (!(value instanceof ILoggedServiceCallList) || !(loggedServiceCallList = (ILoggedServiceCallList)value).VsId().equals(el.getId())) continue;
                    res.add(value);
                }
            }
            return res;
        }
        catch (XPathExpressionException ex) {
            throw new ProjectBuilderException("Error during xpath evaluation.", ex);
        }
    }

    private void init(String projectPassword) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            String res = xpath.evaluate(FIND_ROOT_ID, new InputSource(this.manifest.getData()));
            System.out.println(res);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SVCParseException e) {
            e.printStackTrace();
        }
    }
}

