/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.ant;

import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServiceRuntimeConfiguration;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServiceRuntimeReport;
import com.microfocus.sv.svconfigurator.core.impl.processor.Credentials;
import com.microfocus.sv.svconfigurator.processor.printer.IPrinter;
import com.microfocus.sv.svconfigurator.processor.printer.PrinterFactory;
import com.microfocus.sv.svconfigurator.serverclient.impl.CommandExecutor;
import com.microfocus.sv.svconfigurator.util.AntTaskUtil;
import com.microfocus.sv.svconfigurator.util.HttpUtils;
import com.microfocus.sv.svconfigurator.util.ProjectUtils;
import java.io.File;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ViewTask
extends Task {
    private String service;
    private String username;
    private String password;
    private String url;
    private File projectFile;
    private boolean report;
    private String projectPassword;
    private String outputFormat = PrinterFactory.getDefaultFormat();
    private boolean trustEveryone = false;

    public void execute() throws BuildException {
        this.validate();
        URL mgmtUri = AntTaskUtil.createUri(this.url, null);
        Credentials cred = ProjectUtils.createCredentials(this.username, this.password);
        try {
            CommandExecutor exec = new CommandExecutor(HttpUtils.createServerManagementEndpointClient(mgmtUri, this.trustEveryone, cred));
            IProject proj = this.projectFile != null ? AntTaskUtil.createProject(this.projectFile, this.projectPassword) : null;
            IService svc = exec.findService(this.service, proj);
            IPrinter printer = PrinterFactory.create(this.outputFormat);
            ServiceRuntimeConfiguration conf = exec.getServiceRuntimeInfo(svc);
            ServiceRuntimeReport rep = this.report ? exec.getServiceRuntimeReport(svc) : null;
            this.getProject().log(printer.createServiceInfoOutput(svc, conf, rep));
        }
        catch (CommunicatorException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (CommandExecutorException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void validate() throws BuildException {
        if (this.service == null) {
            throw new BuildException("Service identification (service) has to be set.");
        }
        if (this.url == null) {
            throw new BuildException("Server management URL (url) have to be set.");
        }
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTrustEveryone(boolean trustEveryone) {
        this.trustEveryone = trustEveryone;
    }

    public void setReport(boolean report) {
        this.report = report;
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    public void setProjectPassword(String projectPassword) {
        this.projectPassword = projectPassword;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }
}

