/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.ant;

import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServiceRuntimeConfiguration;
import com.microfocus.sv.svconfigurator.core.impl.processor.Credentials;
import com.microfocus.sv.svconfigurator.serverclient.impl.CommandExecutor;
import com.microfocus.sv.svconfigurator.util.AntTaskUtil;
import com.microfocus.sv.svconfigurator.util.HttpUtils;
import com.microfocus.sv.svconfigurator.util.ProjectUtils;
import com.microfocus.sv.svconfigurator.util.StringUtils;
import java.io.File;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ChmodeTask
extends Task {
    private boolean force = false;
    private String dataModel;
    private String perfModel;
    private File projectFile;
    private String service;
    private String mode;
    private String username;
    private String password;
    private String url;
    private boolean trustEveryone = false;
    private String projectPassword;

    public void execute() throws BuildException {
        this.validateData();
        IProject proj = this.projectFile != null ? AntTaskUtil.createProject(this.projectFile, this.projectPassword) : null;
        Credentials credentials = ProjectUtils.createCredentials(this.username, this.password);
        URL uri = AntTaskUtil.createUri(this.url, proj);
        try {
            CommandExecutor exec = new CommandExecutor(HttpUtils.createServerManagementEndpointClient(uri, this.trustEveryone, credentials));
            exec.setForce(this.force);
            IService svc = proj == null ? exec.findService(this.service, null) : ProjectUtils.findProjElem(proj.getServices(), this.service, "Virtual service");
            ServiceRuntimeConfiguration.RuntimeMode runtMode = this.translateMode(this.mode);
            ServiceRuntimeConfiguration conf = new ServiceRuntimeConfiguration(svc, runtMode, false, ServiceRuntimeConfiguration.DeploymentState.READY);
            if (this.dataModel != null) {
                String dataModelId = ProjectUtils.findProjElem(svc.getDataModels(), this.dataModel, "Data model").getId();
                conf.setDataModelId(dataModelId);
            }
            if (this.perfModel != null) {
                String perfModelId = ProjectUtils.findProjElem(svc.getPerfModels(), this.perfModel, "Performance model").getId();
                conf.setPerfModelId(perfModelId);
            }
            exec.setServiceRuntime(svc, conf);
        }
        catch (CommunicatorException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (CommandExecutorException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void validateData() throws BuildException {
        if (this.service == null) {
            throw new BuildException("Service identification (service) has to be specified.");
        }
        if (this.mode == null) {
            throw new BuildException("Service mode (mode) has to be specified.");
        }
    }

    private ServiceRuntimeConfiguration.RuntimeMode translateMode(String mode) throws BuildException {
        try {
            return ServiceRuntimeConfiguration.RuntimeMode.valueOf(this.mode);
        }
        catch (IllegalArgumentException ex) {
            throw new BuildException("Mode " + mode + " is illegal. You have to use one of (" + StringUtils.joinWithDelim(", ", (Object[])ServiceRuntimeConfiguration.RuntimeMode.values()) + ")");
        }
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setDataModel(String dataModel) {
        this.dataModel = dataModel;
    }

    public void setPerfModel(String perfModel) {
        this.perfModel = perfModel;
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTrustEveryone(boolean trustEveryone) {
        this.trustEveryone = trustEveryone;
    }

    public void setProjectPassword(String projectPassword) {
        this.projectPassword = projectPassword;
    }
}

