/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.causes.CIEventCause;
import com.hp.octane.integrations.dto.causes.CIEventCauseType;
import com.hp.octane.integrations.dto.configuration.CIProxyConfiguration;
import com.hp.octane.integrations.dto.general.OctaneConnectivityStatus;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.codec.Charsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CIPluginSDKUtils {
    private static final Logger logger = LogManager.getLogger(CIPluginSDKUtils.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static void doWait(long period) {
        if (period == 0L) {
            throw new IllegalArgumentException("period MUST be higher than 0");
        }
        long started = System.currentTimeMillis();
        while (System.currentTimeMillis() - started < period) {
            try {
                Thread.sleep(period - (System.currentTimeMillis() - started));
            }
            catch (InterruptedException ie) {
                logger.warn("prematurely interrupted while waiting", (Throwable)ie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doBreakableWait(long period, Object monitor) {
        if (period == 0L) {
            throw new IllegalArgumentException("period MUST be higher than 0");
        }
        if (monitor == null) {
            throw new IllegalArgumentException("monitor MUST NOT be null");
        }
        long started = System.currentTimeMillis();
        while (System.currentTimeMillis() - started < period) {
            try {
                Object object = monitor;
                synchronized (object) {
                    monitor.wait(period - (System.currentTimeMillis() - started));
                    break;
                }
            }
            catch (InterruptedException ie) {
                logger.warn("prematurely interrupted while waiting", (Throwable)ie);
            }
        }
    }

    public static boolean isNonProxyHost(String targetHost, String nonProxyHostsStr) {
        boolean nonProxyHost = false;
        LinkedList<Pattern> nonProxyHostPatterns = new LinkedList<Pattern>();
        if (nonProxyHostsStr != null && !nonProxyHostsStr.isEmpty()) {
            String[] nonProxyHosts;
            nonProxyHostsStr = nonProxyHostsStr.replaceAll("^('|\")|('|\")$", "");
            for (String nph : nonProxyHosts = nonProxyHostsStr.split("[ \t\n,|]+")) {
                if (nph.isEmpty()) continue;
                nonProxyHostPatterns.add(Pattern.compile(nph.replace(".", "\\.").replace("*", ".*")));
            }
        }
        for (Pattern pattern : nonProxyHostPatterns) {
            if (!pattern.matcher(targetHost).find()) continue;
            nonProxyHost = true;
            break;
        }
        return nonProxyHost;
    }

    public static URL parseURL(String input) {
        try {
            return new URL(input);
        }
        catch (MalformedURLException murle) {
            throw new IllegalArgumentException("failed to parse '" + input + "' as URL", murle);
        }
    }

    public static CIProxyConfiguration getProxyConfiguration(String url, OctaneSDK.SDKServicesConfigurer configurer) {
        Function<URL, CIProxyConfiguration> proxySupplier;
        if (configurer != null) {
            proxySupplier = configurer.pluginServices::getProxyConfiguration;
        } else if (OctaneSDK.hasClients()) {
            proxySupplier = OctaneSDK.getClients().get(0).getRestService().getProxySupplier();
        } else {
            return null;
        }
        URL octaneUrl = CIPluginSDKUtils.parseURL(url);
        return proxySupplier.apply(octaneUrl);
    }

    public static String urlEncodePathParam(String input) {
        String result = input;
        if (input != null) {
            try {
                result = URLEncoder.encode(input, StandardCharsets.UTF_8.name()).replace("+", "%20");
            }
            catch (UnsupportedEncodingException uee) {
                logger.error("failed to URL encode '" + input + "', continuing with unchanged original value", (Throwable)uee);
            }
        }
        return result;
    }

    public static String urlEncodeBase64(String input) {
        String result = input;
        if (input != null) {
            result = Base64.getUrlEncoder().encodeToString(input.getBytes(Charsets.UTF_8));
        }
        return result;
    }

    public static String addParameterEncode64ToUrl(String url) {
        String tmp = url + (url.contains("?") ? "&" : "?") + "ci-job-encoding" + "=" + "base64";
        return tmp;
    }

    public static String urlEncodeQueryParam(String input) {
        String result = input;
        if (input != null) {
            try {
                result = URLEncoder.encode(input, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException uee) {
                logger.error("failed to URL encode '" + input + "', continuing with unchanged original value", (Throwable)uee);
            }
        }
        return result;
    }

    public static String inputStreamToUTF8String(InputStream is) throws IOException {
        return CIPluginSDKUtils.inputStreamToString(is, StandardCharsets.UTF_8);
    }

    public static String inputStreamToString(InputStream is, Charset charset) throws IOException {
        int readLen;
        if (is == null) {
            throw new IllegalArgumentException("input stream MUST NOT be null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset MUST NOT be null");
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((readLen = is.read(buffer)) != -1) {
            result.write(buffer, 0, readLen);
        }
        result.flush();
        return result.toString(charset.name());
    }

    public static int compareStringVersion(String version1, String version2) {
        String[] arr1 = version1.split("\\.");
        String[] arr2 = version2.split("\\.");
        for (int i = 0; i < arr1.length || i < arr2.length; ++i) {
            if (i < arr1.length && i < arr2.length) {
                if (Integer.parseInt(arr1[i]) < Integer.parseInt(arr2[i])) {
                    return -1;
                }
                if (Integer.parseInt(arr1[i]) <= Integer.parseInt(arr2[i])) continue;
                return 1;
            }
            if (i < arr1.length) {
                if (Integer.parseInt(arr1[i]) == 0) continue;
                return 1;
            }
            if (i >= arr2.length || Integer.parseInt(arr2[i]) == 0) continue;
            return -1;
        }
        return 0;
    }

    public static boolean isSdkSupported(OctaneConnectivityStatus octaneConnectivityStatus) {
        try {
            return octaneConnectivityStatus.getSupportedSdkVersion() == null || CIPluginSDKUtils.compareStringVersion(OctaneSDK.SDK_VERSION, octaneConnectivityStatus.getSupportedSdkVersion()) >= 0;
        }
        catch (Exception e) {
            logger.error("unable to compare plugin SDK version: " + OctaneSDK.SDK_VERSION + " with Supported SDK version: " + octaneConnectivityStatus.getSupportedSdkVersion() + ". " + e.getMessage());
            return true;
        }
    }

    public static boolean isServiceTemporaryUnavailable(String body) {
        return body != null && body.contains("Service Temporar");
    }

    public static boolean isSharedSpaceIllegal(String body) {
        return body != null && body.contains("requests with illegal sharedspace ID");
    }

    public static void getRootJobCiIds(String jobId, List<CIEventCause> causes, Set<String> parents) {
        if (causes != null) {
            for (CIEventCause cause : causes) {
                if (CIEventCauseType.UPSTREAM.equals((Object)cause.getType())) {
                    CIPluginSDKUtils.getRootJobCiIds(cause.getProject(), cause.getCauses(), parents);
                    continue;
                }
                if (jobId == null || jobId.isEmpty() || parents == null) continue;
                parents.add(jobId);
            }
        }
    }

    public static String getNextCorrelationId() {
        return UUID.randomUUID().toString().replace("-", "").substring(0, 25);
    }
}

