/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.vulnerabilities;

import com.hp.octane.integrations.dto.securityscans.OctaneIssue;
import com.hp.octane.integrations.exceptions.PermanentException;
import com.hp.octane.integrations.services.vulnerabilities.RawVulnerability;
import com.hp.octane.integrations.services.vulnerabilities.VulnerabilitiesGeneralUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class PackIssuesToOctaneUtils {
    public static <T extends RawVulnerability> SortedIssues<T> packToOctaneIssues(List<T> rawIssues, List<String> octaneIssues, boolean calcMissing) {
        if (rawIssues.size() == 0 && octaneIssues.size() == 0) {
            throw new PermanentException("This job run has no issues.");
        }
        List issuesRequiredExtendedData = rawIssues.stream().filter(t -> {
            boolean isMissing = false;
            if (calcMissing) {
                isMissing = !octaneIssues.contains(t.getRemoteId());
            }
            return t.isNew() || isMissing;
        }).collect(Collectors.toList());
        List remoteIdsOfRawIssues = rawIssues.stream().map(t -> t.getRemoteId()).collect(Collectors.toList());
        List remoteIdsToCloseInOctane = octaneIssues.stream().filter(t -> !remoteIdsOfRawIssues.contains(t)).collect(Collectors.toList());
        List<OctaneIssue> closedOctaneIssues = remoteIdsToCloseInOctane.stream().map(VulnerabilitiesGeneralUtils::createClosedOctaneIssue).collect(Collectors.toList());
        List issuesToUpdate = rawIssues.stream().filter(t -> !remoteIdsToCloseInOctane.contains(t.getRemoteId())).collect(Collectors.toList());
        if (issuesToUpdate.size() == 0 && closedOctaneIssues.size() == 0) {
            throw new PermanentException("This job run has no issues.");
        }
        return new SortedIssues(issuesToUpdate, closedOctaneIssues, issuesRequiredExtendedData);
    }

    public static class SortedIssues<T> {
        public List<T> issuesToUpdate;
        public List<T> issuesRequiredExtendedData;
        public List<OctaneIssue> issuesToClose;

        public SortedIssues() {
            this.issuesToUpdate = new ArrayList<T>();
            this.issuesToClose = new ArrayList<OctaneIssue>();
            this.issuesRequiredExtendedData = new ArrayList<T>();
        }

        public SortedIssues(List<T> issuesToUpdate, List<OctaneIssue> issuesToClose, List<T> issuesRequiredExtendedData) {
            this.issuesToUpdate = issuesToUpdate;
            this.issuesToClose = issuesToClose;
            this.issuesRequiredExtendedData = issuesRequiredExtendedData;
        }
    }
}

