/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.vulnerabilities;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DateUtils {
    public static final String sscFormat = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String sonarFormat = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String octaneFormat = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final Logger logger = LogManager.getLogger(DateUtils.class);

    public static String convertDateSSCToOctane(String inputFoundDate, String srcFormat) {
        if (inputFoundDate == null) {
            return null;
        }
        Date date = DateUtils.getDateFromUTCString(inputFoundDate, srcFormat);
        SimpleDateFormat targetDateFormat = new SimpleDateFormat(octaneFormat);
        return targetDateFormat.format(date);
    }

    public static String convertDateToString(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static Date getDateFromUTCString(String inputDate, String format) {
        try {
            SimpleDateFormat sourceDateFormat = new SimpleDateFormat(format);
            sourceDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return sourceDateFormat.parse(inputDate);
        }
        catch (ParseException e) {
            logger.error(e.getMessage());
            logger.error((Object)e.getStackTrace());
            return null;
        }
    }
}

