/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.configuration;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hp.octane.integrations.OctaneConfiguration;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.connectivity.HttpMethod;
import com.hp.octane.integrations.dto.connectivity.OctaneRequest;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.dto.general.OctaneConnectivityStatus;
import com.hp.octane.integrations.exceptions.OctaneConnectivityException;
import com.hp.octane.integrations.services.configuration.ConfigurationService;
import com.hp.octane.integrations.services.configurationparameters.factory.ConfigurationParameterFactory;
import com.hp.octane.integrations.services.rest.RestService;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import com.hp.octane.integrations.utils.SdkStringUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ConfigurationServiceImpl
implements ConfigurationService {
    private static final Logger logger = LogManager.getLogger(ConfigurationServiceImpl.class);
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();
    private static final String CONNECTIVITY_STATUS_URL = "/analytics/ci/servers/connectivity/status";
    private static final String PIPELINE_ROOTS_URL = "/analytics/ci/servers/%s/pipeline-roots";
    private static final String OCTANE_ROOTS_VERSION = "15.1.8";
    private Set<String> octaneRoots = null;
    private static final ObjectMapper mapper = new ObjectMapper();
    private final OctaneSDK.SDKServicesConfigurer configurer;
    private final RestService restService;
    private OctaneConnectivityStatus octaneConnectivityStatus;
    private volatile boolean isConnected;
    private ExecutorService octaneRootsCacheExecutor = Executors.newSingleThreadExecutor();

    ConfigurationServiceImpl(OctaneSDK.SDKServicesConfigurer configurer, RestService restService) {
        if (configurer == null) {
            throw new IllegalArgumentException("invalid configurer");
        }
        if (restService == null) {
            throw new IllegalArgumentException("rest service MUST NOT be null");
        }
        this.configurer = configurer;
        this.restService = restService;
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "initialized SUCCESSFULLY");
    }

    @Override
    public OctaneConfiguration getConfiguration() {
        return this.configurer.octaneConfiguration;
    }

    @Override
    public synchronized OctaneConnectivityStatus getOctaneConnectivityStatus() {
        return this.getOctaneConnectivityStatus(false);
    }

    public synchronized OctaneConnectivityStatus getOctaneConnectivityStatus(boolean forceFetch) {
        try {
            if (forceFetch || this.octaneConnectivityStatus == null) {
                this.octaneConnectivityStatus = this.validateConfigurationAndGetConnectivityStatus();
                logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "octaneConnectivityStatus : " + this.octaneConnectivityStatus);
                this.isConnected = true;
                this.resetOctaneRootsCache();
            }
        }
        catch (Exception e) {
            logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "failed to getOctaneConnectivityStatus : " + e.getMessage());
        }
        return this.octaneConnectivityStatus;
    }

    @Override
    public OctaneConnectivityStatus validateConfigurationAndGetConnectivityStatus() throws IOException {
        OctaneRequest request = ((OctaneRequest)dtoFactory.newDTO(OctaneRequest.class)).setMethod(HttpMethod.GET).setUrl(this.configurer.octaneConfiguration.getUrl() + "/internal-api/shared_spaces/" + this.configurer.octaneConfiguration.getSharedSpace() + CONNECTIVITY_STATUS_URL);
        OctaneResponse response = this.restService.obtainOctaneRestClient().execute(request, this.configurer.octaneConfiguration);
        if (response.getStatus() == 401) {
            throw new OctaneConnectivityException(response.getStatus(), "AUTHENTICATION_FAILURE", "Authentication failure. Check credentials or server location. If using proxy, check that your proxy settings are correct");
        }
        if (response.getStatus() == 403) {
            throw new OctaneConnectivityException(response.getStatus(), "AUTHORIZATION_FAILURE", "Authorization failure. Validate that Client ID is assigned to 'CI/CD Integration' role.");
        }
        if (response.getStatus() == 404) {
            throw new OctaneConnectivityException(response.getStatus(), "CONNECTION_SHARED_SPACE_INVALID", "Unable to connect the shared space");
        }
        if (response.getStatus() == 200) {
            OctaneConnectivityStatus octaneConnectivityStatus = (OctaneConnectivityStatus)DTOFactory.getInstance().dtoFromJson(response.getBody(), OctaneConnectivityStatus.class);
            return octaneConnectivityStatus;
        }
        throw new OctaneConnectivityException(response.getStatus(), "UNEXPECTED_FAILURE", "Connectivity test failed with unexpected failure: " + response.getStatus());
    }

    @Override
    public boolean isOctaneVersionGreaterOrEqual(String version) {
        OctaneConnectivityStatus octaneStatus = this.getOctaneConnectivityStatus();
        return octaneStatus != null && octaneStatus.getOctaneVersion() != null && CIPluginSDKUtils.compareStringVersion(octaneStatus.getOctaneVersion(), version) >= 0;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    public void setConnected(boolean connected) {
        this.isConnected = connected;
    }

    @Override
    public Collection<String> getOctaneRootsCacheCollection() {
        if (this.octaneRoots == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableCollection(this.octaneRoots.stream().sorted().collect(Collectors.toList()));
    }

    @Override
    public Future<Boolean> resetOctaneRootsCache() {
        if (this.isOctaneRootsCacheActivated() && this.isOctaneVersionGreaterOrEqual(OCTANE_ROOTS_VERSION) && !this.configurer.octaneConfiguration.isDisabled()) {
            return this.octaneRootsCacheExecutor.submit(() -> {
                logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "resetOctaneRootCache started");
                try {
                    long startTime = System.currentTimeMillis();
                    String url = this.configurer.octaneConfiguration.getUrl() + "/internal-api/shared_spaces/" + this.configurer.octaneConfiguration.getSharedSpace() + String.format(PIPELINE_ROOTS_URL, this.configurer.octaneConfiguration.getInstanceId());
                    OctaneRequest request = ((OctaneRequest)dtoFactory.newDTO(OctaneRequest.class)).setMethod(HttpMethod.GET).setUrl(url);
                    OctaneResponse response = this.restService.obtainOctaneRestClient().execute(request, this.configurer.octaneConfiguration);
                    this.octaneRoots = (Set)mapper.readValue(response.getBody(), (JavaType)mapper.getTypeFactory().constructCollectionType(Set.class, String.class));
                    logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "resetOctaneRootCache: successfully update octane roots, found " + this.octaneRoots.size() + " roots, processing time is " + (System.currentTimeMillis() - startTime) / 1000L + " seconds");
                    return true;
                }
                catch (Exception e) {
                    logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "Failed to resetOctaneRootCache : " + e.getMessage());
                    return false;
                }
            });
        }
        if (this.octaneRoots != null) {
            logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "resetOctaneRootsCache : cache is cleared");
        }
        this.octaneRoots = null;
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public void addToOctaneRootsCache(String rootJob) {
        if (this.octaneRoots != null && SdkStringUtils.isNotEmpty(rootJob) && this.octaneRoots.add(rootJob)) {
            logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "addToOctaneRootsCache: new root is added [" + rootJob + "]");
        }
    }

    @Override
    public boolean removeFromOctaneRoots(String rootJob) {
        if (this.octaneRoots != null) {
            return this.octaneRoots.remove(rootJob);
        }
        return false;
    }

    public boolean isRelevantForOctane(String rootJobs) {
        if (rootJobs == null) {
            return true;
        }
        Collection<String> parents = rootJobs.contains(";") ? Arrays.asList(rootJobs.split(";")) : Collections.singleton(rootJobs);
        return this.isRelevantForOctane(parents);
    }

    @Override
    public boolean isRelevantForOctane(Collection<String> rootJobs) {
        if (this.isOctaneRootsCacheActivated() && this.octaneRoots != null && rootJobs != null && !rootJobs.isEmpty()) {
            for (String rootJob : rootJobs) {
                if (SdkStringUtils.isEmpty(rootJob)) continue;
                if (this.octaneRoots.contains(rootJob)) {
                    return true;
                }
                String parentJobName = this.configurer.pluginServices.getParentJobName(rootJob);
                if (parentJobName == null || !this.octaneRoots.contains(parentJobName)) continue;
                this.addToOctaneRootsCache(rootJob);
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isOctaneRootsCacheActivated() {
        return ConfigurationParameterFactory.octaneRootsCacheAllowed(this.configurer.octaneConfiguration);
    }

    @Override
    public Map<String, Object> getMetrics() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("isOctaneRootsCacheActivated", this.isOctaneRootsCacheActivated());
        if (this.isOctaneRootsCacheActivated() && this.octaneRoots != null) {
            map.put("octaneRootsCache_jobCount", this.octaneRoots.size());
        }
        return map;
    }
}

