/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.bridge;

import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.DTOBase;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.connectivity.HttpMethod;
import com.hp.octane.integrations.dto.connectivity.OctaneRequest;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.dto.connectivity.OctaneResultAbridged;
import com.hp.octane.integrations.dto.connectivity.OctaneTaskAbridged;
import com.hp.octane.integrations.dto.general.CIPluginInfo;
import com.hp.octane.integrations.dto.general.CIServerInfo;
import com.hp.octane.integrations.dto.general.CIServerTypes;
import com.hp.octane.integrations.services.bridge.BridgeService;
import com.hp.octane.integrations.services.bridge.ServiceState;
import com.hp.octane.integrations.services.configuration.ConfigurationService;
import com.hp.octane.integrations.services.configuration.ConfigurationServiceImpl;
import com.hp.octane.integrations.services.rest.OctaneRestClient;
import com.hp.octane.integrations.services.rest.RestService;
import com.hp.octane.integrations.services.tasking.TasksProcessor;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class BridgeServiceImpl
implements BridgeService {
    private static final Logger logger = LogManager.getLogger(BridgeServiceImpl.class);
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();
    private final Set<String> failedSharedSpaces = new HashSet<String>();
    private final ExecutorService connectivityExecutors = Executors.newFixedThreadPool(5, new AbridgedConnectivityExecutorsFactory());
    private final ExecutorService taskProcessingExecutors = Executors.newFixedThreadPool(10, new AbridgedTasksExecutorsFactory());
    private final OctaneSDK.SDKServicesConfigurer configurer;
    private final RestService restService;
    private final ConfigurationService configurationService;
    private final TasksProcessor tasksProcessor;
    private long lastLogTime = 0L;
    private static final long MILLI_TO_HOUR = 3600000L;
    private long continuousExceptionsCounter = 0L;
    private long forcedGetOctaneConnectivityStatusCalls = 0L;
    private long lastRequestToOctaneTime = 0L;
    private ServiceState serviceState = ServiceState.Initial;
    private long stateStartTime = 0L;
    private long requestTimeoutCount = 0L;
    private long lastRequestTimeoutTime = 0L;
    private final int PUT_ABRIDGE_RESULT_TIMEOUT;

    BridgeServiceImpl(OctaneSDK.SDKServicesConfigurer configurer, RestService restService, TasksProcessor tasksProcessor, ConfigurationService configurationService) {
        int n = this.PUT_ABRIDGE_RESULT_TIMEOUT = System.getProperty("octane.sdk.bridge.abridge_result_timeout") != null ? Integer.parseInt(System.getProperty("octane.sdk.bridge.abridge_result_timeout")) : 20;
        if (configurer == null) {
            throw new IllegalArgumentException("invalid configurer");
        }
        if (restService == null) {
            throw new IllegalArgumentException("rest service MUST NOT be null");
        }
        if (tasksProcessor == null) {
            throw new IllegalArgumentException("task processor MUST NOT be null");
        }
        if (configurationService == null) {
            throw new IllegalArgumentException("configuration service MUST NOT be null");
        }
        this.configurationService = configurationService;
        this.configurer = configurer;
        this.restService = restService;
        this.tasksProcessor = tasksProcessor;
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "starting background worker...");
        this.connectivityExecutors.execute(this::worker);
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "initialized SUCCESSFULLY");
    }

    @Override
    public Map<String, Object> getMetrics() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("isShutdown", this.isShutdown());
        map.put("state", this.serviceState.name());
        map.put("stateStartTime", new Date(this.stateStartTime));
        map.put("lastRequestToOctaneTime", new Date(this.lastRequestToOctaneTime));
        map.put("connectivityExecutors.getActiveCount", ((ThreadPoolExecutor)this.connectivityExecutors).getActiveCount());
        map.put("requestTimeoutCount", this.requestTimeoutCount);
        map.put("forcedGetOctaneConnectivityStatus.calls", this.forcedGetOctaneConnectivityStatusCalls);
        map.put("continuousExceptionsCounter", this.continuousExceptionsCounter);
        if (this.lastRequestTimeoutTime > 0L) {
            map.put("lastRequestTimeoutTime", new Date(this.lastRequestTimeoutTime));
        }
        return map;
    }

    @Override
    public void shutdown() {
        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "shutdown");
        this.connectivityExecutors.shutdown();
        this.taskProcessingExecutors.shutdown();
        this.changeServiceState(ServiceState.Closed);
    }

    @Override
    public boolean isShutdown() {
        return this.connectivityExecutors.isShutdown() || this.taskProcessingExecutors.isShutdown();
    }

    private void worker() {
        try {
            String tasksJSON = null;
            CIServerInfo serverInfo = this.configurer.pluginServices.getServerInfo();
            CIPluginInfo pluginInfo = this.configurer.pluginServices.getPluginInfo();
            String client = this.configurer.octaneConfiguration.getClient();
            if (BridgeServiceImpl.hoursDifference(System.currentTimeMillis(), this.lastLogTime) >= 1L) {
                String status = "active";
                if (this.configurer.octaneConfiguration.isSuspended()) {
                    status = "suspended";
                } else if (!this.configurer.octaneConfiguration.isSdkSupported()) {
                    status = "deactivated (sdk is not supported)";
                }
                logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "task polling is " + status);
                this.lastLogTime = System.currentTimeMillis();
            }
            if (this.configurer.octaneConfiguration.isDisabled()) {
                this.changeServiceState(ServiceState.Disabled);
                CIPluginSDKUtils.doWait(20000L);
            } else {
                tasksJSON = this.getAbridgedTasks(this.configurer.octaneConfiguration.getInstanceId(), serverInfo.getType() == null ? CIServerTypes.UNKNOWN.value() : serverInfo.getType(), serverInfo.getUrl() == null ? "" : serverInfo.getUrl(), pluginInfo == null || pluginInfo.getVersion() == null ? "" : pluginInfo.getVersion(), client == null ? "" : client, this.configurer.octaneConfiguration.getImpersonatedUser() == null ? "" : this.configurer.octaneConfiguration.getImpersonatedUser());
            }
            if (!this.connectivityExecutors.isShutdown()) {
                this.connectivityExecutors.execute(this::worker);
            } else {
                this.changeServiceState(ServiceState.StopTaskPolling);
                logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "Shutdown flag is up - stop task processing");
            }
            if (tasksJSON != null && !tasksJSON.isEmpty()) {
                this.handleTasks(tasksJSON);
            }
        }
        catch (Throwable t) {
            try {
                this.breathingOnException("getting tasks from Octane Server temporary failed", 2, t);
                if (!this.connectivityExecutors.isShutdown()) {
                    this.connectivityExecutors.execute(this::worker);
                } else {
                    this.changeServiceState(ServiceState.StopTaskPolling);
                    logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "Shutdown flag is up - stop task processing");
                }
            }
            catch (Throwable t2) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "unexpected exception in BridgeServiceImpl.worker", t2);
            }
        }
    }

    private void changeServiceState(ServiceState newState) {
        if (!this.serviceState.equals((Object)newState)) {
            this.stateStartTime = System.currentTimeMillis();
        }
        this.serviceState = newState;
        if (newState.equals((Object)ServiceState.WaitingToOctane)) {
            this.lastRequestToOctaneTime = System.currentTimeMillis();
        }
    }

    private String getAbridgedTasks(String selfIdentity, String selfType, String selfUrl, String pluginVersion, String octaneUser, String ciServerUser) {
        if (this.failedSharedSpaces.contains(this.configurer.octaneConfiguration.getSharedSpace() + this.configurer.octaneConfiguration.getInstanceId())) {
            return null;
        }
        String responseBody = null;
        OctaneRestClient octaneRestClient = this.restService.obtainOctaneRestClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("accept", ContentType.APPLICATION_JSON.getMimeType());
        OctaneRequest octaneRequest = ((OctaneRequest)dtoFactory.newDTO(OctaneRequest.class)).setMethod(HttpMethod.GET).setTimeoutSec(60).setUrl(this.configurer.octaneConfiguration.getUrl() + "/internal-api/shared_spaces/" + this.configurer.octaneConfiguration.getSharedSpace() + "/analytics/ci/" + "servers/" + selfIdentity + "/tasks?self-type=" + CIPluginSDKUtils.urlEncodeQueryParam(selfType) + "&self-url=" + CIPluginSDKUtils.urlEncodeQueryParam(selfUrl) + "&api-version=" + OctaneSDK.API_VERSION + "&sdk-version=" + CIPluginSDKUtils.urlEncodeQueryParam(OctaneSDK.SDK_VERSION) + "&plugin-version=" + CIPluginSDKUtils.urlEncodeQueryParam(pluginVersion) + "&client-id=" + CIPluginSDKUtils.urlEncodeQueryParam(octaneUser) + "&ci-server-user=" + CIPluginSDKUtils.urlEncodeQueryParam(ciServerUser)).setHeaders(headers);
        try {
            this.changeServiceState(ServiceState.WaitingToOctane);
            OctaneResponse octaneResponse = octaneRestClient.execute(octaneRequest);
            this.changeServiceState(ServiceState.AfterWaitingToOctane);
            if (octaneResponse.getStatus() == 200) {
                responseBody = octaneResponse.getBody();
                if (CIPluginSDKUtils.isServiceTemporaryUnavailable(responseBody)) {
                    this.breathingOnException("Saas service is temporary unavailable.", 60, null);
                    responseBody = null;
                } else {
                    this.setConnectionSuccessful();
                }
            } else if (octaneResponse.getStatus() == 204) {
                logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + "no tasks found on server");
                this.setConnectionSuccessful();
            } else if (CIPluginSDKUtils.isSharedSpaceIllegal(octaneResponse.getBody())) {
                this.failedSharedSpaces.add(this.configurer.octaneConfiguration.getSharedSpace() + this.configurer.octaneConfiguration.getInstanceId());
            } else if (octaneResponse.getStatus() == 408) {
                logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + "expected timeout disconnection on retrieval of abridged tasks, reconnecting immediately...");
                this.setConnectionSuccessful();
            } else if (octaneResponse.getStatus() == 503 || octaneResponse.getStatus() == 502) {
                this.breathingOnException("Octane service is unavailable.", 30, null);
            } else if (octaneResponse.getStatus() == 401) {
                this.breathingOnException("Connection to Octane failed: authentication error.", 30, null);
            } else if (octaneResponse.getStatus() == 403) {
                this.breathingOnException("Connection to Octane failed: authorization error.", 30, null);
            } else if (octaneResponse.getStatus() == 404) {
                this.breathingOnException("Connection to Octane failed: 404, validate proxy settings, maybe missing 'No Proxy Host' setting?", 30, null);
            } else if (octaneResponse.getStatus() == 307) {
                this.breathingOnException("Task polling request is redirected. Possibly Octane service is unavailable now.", 30, null);
            } else {
                String output = octaneResponse.getBody() == null ? "" : octaneResponse.getBody().substring(0, Math.min(octaneResponse.getBody().length(), 2000));
                this.breathingOnException("Unexpected response from Octane; status: " + octaneResponse.getStatus() + ", content: " + output + ".", 20, null);
            }
        }
        catch (InterruptedIOException ie) {
            ++this.requestTimeoutCount;
            this.lastRequestTimeoutTime = System.currentTimeMillis();
            long timeout = (this.lastRequestTimeoutTime - this.stateStartTime) / 1000L;
            this.breathingOnException("!!!!!!!!!!!!!!!!!!! request timeout after request timeout after " + timeout + " sec", 5, ie);
        }
        catch (SocketException | UnknownHostException e) {
            this.breathingOnException("Failed to retrieve abridged tasks. ALM Octane Server is not accessible", 30, e);
        }
        catch (IOException ioe) {
            this.breathingOnException("Failed to retrieve abridged tasks", 30, ioe);
        }
        catch (Throwable t) {
            this.breathingOnException("Unexpected error during retrieval of abridged tasks", 30, t);
        }
        return responseBody;
    }

    private void setConnectionSuccessful() {
        ((ConfigurationServiceImpl)this.configurationService).setConnected(true);
        if (this.continuousExceptionsCounter > 4L) {
            logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "force getOctaneConnectivityStatus after " + this.continuousExceptionsCounter + " failed trials");
            ((ConfigurationServiceImpl)this.configurationService).getOctaneConnectivityStatus(true);
            ++this.forcedGetOctaneConnectivityStatusCalls;
        }
        this.continuousExceptionsCounter = 0L;
    }

    private void breathingOnException(String msg, int secs, Throwable t) {
        ((ConfigurationServiceImpl)this.configurationService).setConnected(false);
        ++this.continuousExceptionsCounter;
        String error = t == null ? "" : " : " + t.getClass().getCanonicalName() + " - " + t.getMessage();
        logger.error(this.configurer.octaneConfiguration.getLocationForLog() + msg + error + ". Breathing " + secs + " secs.");
        this.changeServiceState(ServiceState.PostponingOnException);
        CIPluginSDKUtils.doWait(secs * 1000);
    }

    private void handleTasks(String tasksJSON) {
        try {
            logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "parsing tasks...");
            OctaneTaskAbridged[] tasks = (OctaneTaskAbridged[])dtoFactory.dtoCollectionFromJson(tasksJSON, OctaneTaskAbridged[].class);
            logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "parsed " + tasks.length + " tasks, processing...");
            for (OctaneTaskAbridged task : tasks) {
                if (!this.taskProcessingExecutors.isShutdown()) {
                    this.taskProcessingExecutors.execute(() -> {
                        OctaneResultAbridged result = this.tasksProcessor.execute(task);
                        int submitStatus = this.putAbridgedResult(this.configurer.octaneConfiguration.getInstanceId(), result.getId(), result, false);
                        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "result for task '" + result.getId() + "' submitted with status " + submitStatus);
                    });
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "failed to process tasks", (Throwable)e);
        }
    }

    private int putAbridgedResult(String selfIdentity, String taskId, OctaneResultAbridged result, boolean rerun) {
        InputStream contentJSON = dtoFactory.dtoToJsonStream((DTOBase)result);
        OctaneRestClient octaneRestClientImpl = this.restService.obtainOctaneRestClient();
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put("content-type", ContentType.APPLICATION_JSON.getMimeType());
        OctaneRequest octaneRequest = ((OctaneRequest)dtoFactory.newDTO(OctaneRequest.class)).setMethod(HttpMethod.PUT).setUrl(this.configurer.octaneConfiguration.getUrl() + "/internal-api/shared_spaces/" + this.configurer.octaneConfiguration.getSharedSpace() + "/analytics/ci/" + "servers/" + selfIdentity + "/tasks/" + taskId + "/result").setHeaders(headers).setBody(contentJSON).setTimeoutSec(this.PUT_ABRIDGE_RESULT_TIMEOUT);
        long start = System.currentTimeMillis();
        try {
            OctaneResponse octaneResponse = octaneRestClientImpl.execute(octaneRequest);
            return octaneResponse.getStatus();
        }
        catch (IOException ioe) {
            logger.error("{}failed to submit abridged task's result {}, rerun = {}, start = {} ,timeout = {} sec, took = {} ms", (Object)taskId, (Object)this.configurer.octaneConfiguration.getLocationForLog(), (Object)rerun, (Object)new SimpleDateFormat("dd/MM/yyyy HH:mm:ss,SSS").format(new Date(start)), (Object)this.PUT_ABRIDGE_RESULT_TIMEOUT, (Object)(System.currentTimeMillis() - start), (Object)ioe);
            if (!rerun) {
                CIPluginSDKUtils.doWait(1000L);
                return this.putAbridgedResult(selfIdentity, taskId, result, true);
            }
            return 0;
        }
    }

    private static long hoursDifference(long date1, long date2) {
        return (date1 - date2) / 3600000L;
    }

    private static final class AbridgedTasksExecutorsFactory
    implements ThreadFactory {
        private AbridgedTasksExecutorsFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread result = new Thread(runnable);
            result.setName("AbridgedTasksWorker-" + result.getId());
            result.setDaemon(true);
            return result;
        }
    }

    private static final class AbridgedConnectivityExecutorsFactory
    implements ThreadFactory {
        private AbridgedConnectivityExecutorsFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread result = new Thread(runnable);
            result.setName("AbridgedConnectivityWorker-" + result.getId());
            result.setDaemon(true);
            return result;
        }
    }
}

