/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.hiddenlayer;

import com.hiddenlayer.api.core.RequestOptions;
import com.hiddenlayer.api.core.Timeout;
import com.hiddenlayer.api.core.http.Headers;
import com.hiddenlayer.api.core.http.HttpClient;
import com.hiddenlayer.api.core.http.HttpMethod;
import com.hiddenlayer.api.core.http.HttpRequest;
import com.hiddenlayer.api.core.http.HttpRequestBody;
import com.hiddenlayer.api.core.http.HttpResponse;
import com.hiddenlayer.api.core.http.QueryParams;
import com.hiddenlayer.api.errors.HiddenLayerIoException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Authenticator;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import okio.BufferedSink;

public class JenkinsHttpClient
implements HttpClient {
    private final OkHttpClient okHttpClient;

    private JenkinsHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    public HttpResponse execute(HttpRequest request, RequestOptions requestOptions) {
        Call call = this.newCall(request, requestOptions);
        try {
            HttpResponse httpResponse = this.toResponse(call.execute());
            return httpResponse;
        }
        catch (IOException e) {
            throw new HiddenLayerIoException("Request failed", (Throwable)e);
        }
        finally {
            HttpRequestBody requestBody = request.body();
            if (requestBody != null) {
                requestBody.close();
            }
        }
    }

    public CompletableFuture<HttpResponse> executeAsync(HttpRequest request, RequestOptions requestOptions) {
        final CompletableFuture<HttpResponse> future = new CompletableFuture<HttpResponse>();
        Call call = this.newCall(request, requestOptions);
        call.enqueue(new Callback(){

            public void onResponse(Call call, Response response) {
                future.complete(JenkinsHttpClient.this.toResponse(response));
            }

            public void onFailure(Call call, IOException e) {
                future.completeExceptionally((Throwable)new HiddenLayerIoException("Request failed", (Throwable)e));
            }
        });
        future.whenComplete((result, e) -> {
            HttpRequestBody requestBody;
            if (e instanceof CancellationException) {
                call.cancel();
            }
            if ((requestBody = request.body()) != null) {
                requestBody.close();
            }
        });
        return future;
    }

    public void close() {
        this.okHttpClient.dispatcher().executorService().shutdown();
        this.okHttpClient.connectionPool().evictAll();
        Cache cache = this.okHttpClient.cache();
        if (cache != null) {
            try {
                cache.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private Call newCall(HttpRequest request, RequestOptions requestOptions) {
        Timeout timeout;
        OkHttpClient.Builder clientBuilder = this.okHttpClient.newBuilder();
        String logLevel = System.getenv("HIDDENLAYER_LOG");
        if (logLevel != null) {
            HttpLoggingInterceptor.Level level = null;
            if ("info".equalsIgnoreCase(logLevel)) {
                level = HttpLoggingInterceptor.Level.BASIC;
            } else if ("debug".equalsIgnoreCase(logLevel)) {
                level = HttpLoggingInterceptor.Level.BODY;
            }
            if (level != null) {
                HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
                interceptor.setLevel(level);
                interceptor.redactHeader("Authorization");
                clientBuilder.addNetworkInterceptor((Interceptor)interceptor);
            }
        }
        if ((timeout = requestOptions.getTimeout()) != null) {
            clientBuilder.connectTimeout(timeout.connect()).readTimeout(timeout.read()).writeTimeout(timeout.write()).callTimeout(timeout.request());
        }
        OkHttpClient client = clientBuilder.build();
        return client.newCall(this.toOkHttpRequest(request, client));
    }

    private Request toOkHttpRequest(HttpRequest request, OkHttpClient client) {
        HttpUrl parsedUrl;
        RequestBody body = null;
        HttpRequestBody httpRequestBody = request.body();
        if (httpRequestBody != null) {
            body = this.toOkHttpRequestBody(httpRequestBody);
        }
        if (body == null && this.requiresBody(request.method())) {
            body = RequestBody.create((String)"", null);
        }
        if ((parsedUrl = HttpUrl.parse((String)request.baseUrl())) == null) {
            throw new HiddenLayerIoException("Invalid base URL: " + request.baseUrl(), null);
        }
        HttpUrl.Builder urlBuilder = parsedUrl.newBuilder();
        for (Object segment : request.pathSegments()) {
            urlBuilder.addPathSegment((String)segment);
        }
        QueryParams queryParams = request.queryParams();
        if (queryParams != null) {
            for (String key : queryParams.keys()) {
                for (String value : queryParams.values(key)) {
                    urlBuilder.addQueryParameter(key, value);
                }
            }
        }
        Request.Builder builder = new Request.Builder().url(urlBuilder.build()).method(request.method().name(), body);
        com.hiddenlayer.api.core.http.Headers headers = request.headers();
        for (String name : headers.names()) {
            for (String value : headers.values(name)) {
                builder.addHeader(name, value);
            }
        }
        if (!headers.names().contains("X-Stainless-Read-Timeout") && client.readTimeoutMillis() != 0) {
            builder.addHeader("X-Stainless-Read-Timeout", String.valueOf(Duration.ofMillis(client.readTimeoutMillis()).getSeconds()));
        }
        if (!headers.names().contains("X-Stainless-Timeout") && client.callTimeoutMillis() != 0) {
            builder.addHeader("X-Stainless-Timeout", String.valueOf(Duration.ofMillis(client.callTimeoutMillis()).getSeconds()));
        }
        return builder.build();
    }

    private boolean requiresBody(HttpMethod method) {
        return method == HttpMethod.POST || method == HttpMethod.PUT || method == HttpMethod.PATCH;
    }

    private RequestBody toOkHttpRequestBody(final HttpRequestBody body) {
        String contentType = body.contentType();
        final MediaType mediaType = contentType != null ? MediaType.parse((String)contentType) : null;
        final long length = body.contentLength();
        return new RequestBody(){

            public MediaType contentType() {
                return mediaType;
            }

            public long contentLength() {
                return length;
            }

            public boolean isOneShot() {
                return !body.repeatable();
            }

            public void writeTo(BufferedSink sink) throws IOException {
                body.writeTo(sink.outputStream());
            }
        };
    }

    private HttpResponse toResponse(final Response response) {
        final com.hiddenlayer.api.core.http.Headers headers = this.toHeaders(response.headers());
        final ResponseBody responseBody = response.body();
        return new HttpResponse(){

            public int statusCode() {
                return response.code();
            }

            public com.hiddenlayer.api.core.http.Headers headers() {
                return headers;
            }

            public InputStream body() {
                if (responseBody == null) {
                    return InputStream.nullInputStream();
                }
                return responseBody.byteStream();
            }

            public void close() {
                if (responseBody != null) {
                    responseBody.close();
                }
            }
        };
    }

    private com.hiddenlayer.api.core.http.Headers toHeaders(Headers okHeaders) {
        Headers.Builder builder = com.hiddenlayer.api.core.http.Headers.builder();
        for (int i = 0; i < okHeaders.size(); ++i) {
            builder.put(okHeaders.name(i), okHeaders.value(i));
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Timeout timeout = Timeout.builder().build();
        private Proxy proxy = null;
        private Authenticator proxyAuthenticator = null;

        public Builder timeout(Timeout timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = Timeout.builder().request(timeout).build();
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyAuthenticator(Authenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }

        public JenkinsHttpClient build() {
            OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(this.timeout.connect()).readTimeout(this.timeout.read()).writeTimeout(this.timeout.write()).callTimeout(this.timeout.request());
            if (this.proxy != null) {
                builder.proxy(this.proxy);
            }
            if (this.proxyAuthenticator != null) {
                builder.proxyAuthenticator(this.proxyAuthenticator);
            }
            OkHttpClient client = builder.build();
            client.dispatcher().setMaxRequestsPerHost(client.dispatcher().getMaxRequests());
            return new JenkinsHttpClient(client);
        }
    }
}

