/*
 * Decompiled with CFR 0.152.
 */
package com.hiddenlayer.api.core.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.hiddenlayer.api.core.Check;
import com.hiddenlayer.api.core.JsonField;
import com.hiddenlayer.api.core.RequestOptions;
import com.hiddenlayer.api.core.Utils;
import com.hiddenlayer.api.core.handlers.ErrorHandler;
import com.hiddenlayer.api.core.http.HttpClient;
import com.hiddenlayer.api.core.http.HttpMethod;
import com.hiddenlayer.api.core.http.HttpRequest;
import com.hiddenlayer.api.core.http.HttpResponse;
import com.hiddenlayer.api.errors.HiddenLayerInvalidDataException;
import com.hiddenlayer.api.errors.HiddenLayerRetryableException;
import java.time.Clock;
import java.time.Instant;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 (2\u00020\u0001:\u0003'()B7\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001f2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010 \u001a\u00020\u0004H\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u001fH\u0002J\b\u0010\"\u001a\u00020\u0019H\u0002J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u0004H\u0002J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040\u001fH\u0002R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/hiddenlayer/api/core/http/OAuth2HttpClient;", "Lcom/hiddenlayer/api/core/http/HttpClient;", "httpClient", "tokenUrl", "", "clientId", "clientSecret", "jsonMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "clock", "Ljava/time/Clock;", "(Lcom/hiddenlayer/api/core/http/HttpClient;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/fasterxml/jackson/databind/json/JsonMapper;Ljava/time/Clock;)V", "accessToken", "errorHandler", "Lcom/hiddenlayer/api/core/http/HttpResponse$Handler;", "Lcom/hiddenlayer/api/core/http/HttpResponse;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "responseBodyHandler", "Lcom/hiddenlayer/api/core/http/OAuth2HttpClient$ResponseBody;", "tokenExpiresAt", "Ljava/time/Instant;", "buildAccessTokenRequest", "Lcom/hiddenlayer/api/core/http/HttpRequest;", "close", "", "execute", "request", "requestOptions", "Lcom/hiddenlayer/api/core/RequestOptions;", "executeAsync", "Ljava/util/concurrent/CompletableFuture;", "getOrFetchAccessToken", "getOrFetchAccessTokenAsync", "invalidateTokenUnsafe", "isTokenExpired", "", "refreshTokenUnsafe", "refreshTokenUnsafeAsync", "Builder", "Companion", "ResponseBody", "hiddenlayer-java-core"})
@SourceDebugExtension(value={"SMAP\nOAuth2HttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuth2HttpClient.kt\ncom/hiddenlayer/api/core/http/OAuth2HttpClient\n+ 2 JsonHandler.kt\ncom/hiddenlayer/api/core/handlers/JsonHandler\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n13#2,8:200\n1#3:208\n*S KotlinDebug\n*F\n+ 1 OAuth2HttpClient.kt\ncom/hiddenlayer/api/core/http/OAuth2HttpClient\n*L\n37#1:200,8\n*E\n"})
public final class OAuth2HttpClient
implements HttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final String tokenUrl;
    @NotNull
    private final String clientId;
    @NotNull
    private final String clientSecret;
    @NotNull
    private final JsonMapper jsonMapper;
    @NotNull
    private final Clock clock;
    @Nullable
    private String accessToken;
    @Nullable
    private Instant tokenExpiresAt;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private final HttpResponse.Handler<HttpResponse> errorHandler;
    @NotNull
    private final HttpResponse.Handler<ResponseBody> responseBodyHandler;

    private OAuth2HttpClient(HttpClient httpClient, String tokenUrl, String clientId, String clientSecret, JsonMapper jsonMapper, Clock clock) {
        this.httpClient = httpClient;
        this.tokenUrl = tokenUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.jsonMapper = jsonMapper;
        this.clock = clock;
        this.lock = new ReentrantLock();
        this.errorHandler = ErrorHandler.errorHandler(ErrorHandler.errorBodyHandler(this.jsonMapper));
        JsonMapper jsonMapper$iv = this.jsonMapper;
        boolean $i$f$jsonHandler = false;
        this.responseBodyHandler = new HttpResponse.Handler<ResponseBody>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public ResponseBody handle(@NotNull HttpResponse response) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    object = this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ResponseBody>(){});
                }
                catch (Exception e) {
                    throw new HiddenLayerInvalidDataException("Error reading response", e);
                }
                return object;
            }
        };
    }

    @Override
    @NotNull
    public HttpResponse execute(@NotNull HttpRequest request2, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String token = this.getOrFetchAccessToken();
        String authorizationHeader = "Bearer " + token;
        HttpRequest requestWithAuth = request2.toBuilder().putHeader("Authorization", authorizationHeader).build();
        HttpResponse response = this.httpClient.execute(requestWithAuth, requestOptions);
        if (response.statusCode() == 401) {
            response.close();
            if (this.isTokenExpired()) {
                throw new HiddenLayerRetryableException("OAuth token is expired", null, 2, null);
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getOrFetchAccessToken() {
        String string;
        Lock lock = this.lock;
        lock.lock();
        try {
            String string2;
            block7: {
                block6: {
                    String string3;
                    boolean bl = false;
                    string2 = this.accessToken;
                    if (string2 == null) break block6;
                    String it = string3 = string2;
                    boolean bl2 = false;
                    string2 = !this.isTokenExpired() ? string3 : null;
                    if (string2 != null) break block7;
                }
                OAuth2HttpClient $this$getOrFetchAccessToken_u24lambda_u242_u24lambda_u241 = this;
                boolean bl = false;
                $this$getOrFetchAccessToken_u24lambda_u242_u24lambda_u241.invalidateTokenUnsafe();
                string2 = $this$getOrFetchAccessToken_u24lambda_u242_u24lambda_u241.refreshTokenUnsafe();
            }
            string = string2;
        }
        finally {
            lock.unlock();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String refreshTokenUnsafe() {
        String string;
        AutoCloseable autoCloseable = this.httpClient.execute(this.buildAccessTokenRequest());
        Throwable throwable = null;
        try {
            ResponseBody responseBody;
            HttpResponse response = (HttpResponse)autoCloseable;
            boolean bl = false;
            ResponseBody it = responseBody = this.responseBodyHandler.handle(this.errorHandler.handle(response));
            boolean bl2 = false;
            this.tokenExpiresAt = Instant.now(this.clock).plusSeconds(it.expiresIn());
            this.accessToken = it.accessToken();
            string = responseBody.accessToken();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return string;
    }

    @Override
    @NotNull
    public CompletableFuture<HttpResponse> executeAsync(@NotNull HttpRequest request2, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        CompletionStage completionStage = ((CompletableFuture)this.getOrFetchAccessTokenAsync().thenCompose(arg_0 -> OAuth2HttpClient.executeAsync$lambda$5((Function1)new Function1<String, CompletionStage<HttpResponse>>(request2, this, requestOptions){
            final /* synthetic */ HttpRequest $request;
            final /* synthetic */ OAuth2HttpClient this$0;
            final /* synthetic */ RequestOptions $requestOptions;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                this.$requestOptions = $requestOptions;
                super(1);
            }

            public final CompletionStage<HttpResponse> invoke(String token) {
                String authorizationHeader = "Bearer " + token;
                HttpRequest requestWithAuth = this.$request.toBuilder().putHeader("Authorization", authorizationHeader).build();
                return OAuth2HttpClient.access$getHttpClient$p(this.this$0).executeAsync(requestWithAuth, this.$requestOptions);
            }
        }, arg_0))).thenApply(arg_0 -> OAuth2HttpClient.executeAsync$lambda$6((Function1)new Function1<HttpResponse, HttpResponse>(this){
            final /* synthetic */ OAuth2HttpClient this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final HttpResponse invoke(HttpResponse response) {
                if (response.statusCode() == 401) {
                    response.close();
                    if (OAuth2HttpClient.access$isTokenExpired(this.this$0)) {
                        throw new HiddenLayerRetryableException("OAuth token is expired", null, 2, null);
                    }
                }
                return response;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"override fun executeAsyn\u2026   response\n            }");
        return completionStage;
    }

    private final CompletableFuture<String> getOrFetchAccessTokenAsync() {
        return Utils.withLockAsync(this.lock, (Function0)new Function0<CompletableFuture<String>>(this){
            final /* synthetic */ OAuth2HttpClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CompletableFuture<String> invoke() {
                String string = OAuth2HttpClient.access$getAccessToken$p(this.this$0);
                if (string != null) {
                    String string2 = string;
                    OAuth2HttpClient oAuth2HttpClient = this.this$0;
                    String it = string2;
                    boolean bl = false;
                    if (!OAuth2HttpClient.access$isTokenExpired(oAuth2HttpClient)) {
                        CompletableFuture<String> completableFuture = CompletableFuture.completedFuture(it);
                        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(it)");
                        return completableFuture;
                    }
                }
                OAuth2HttpClient.access$invalidateTokenUnsafe(this.this$0);
                return OAuth2HttpClient.access$refreshTokenUnsafeAsync(this.this$0);
            }
        });
    }

    private final CompletableFuture<String> refreshTokenUnsafeAsync() {
        CompletionStage completionStage = this.httpClient.executeAsync(this.buildAccessTokenRequest()).thenApply(arg_0 -> OAuth2HttpClient.refreshTokenUnsafeAsync$lambda$7((Function1)new Function1<HttpResponse, String>(this){
            final /* synthetic */ OAuth2HttpClient this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final String invoke(HttpResponse response) {
                HttpResponse.Handler handler = OAuth2HttpClient.access$getResponseBodyHandler$p(this.this$0);
                HttpResponse.Handler handler2 = OAuth2HttpClient.access$getErrorHandler$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
                T t = handler.handle((HttpResponse)handler2.handle(response));
                OAuth2HttpClient oAuth2HttpClient = this.this$0;
                ResponseBody it = (ResponseBody)t;
                boolean bl = false;
                OAuth2HttpClient.access$setTokenExpiresAt$p(oAuth2HttpClient, Instant.now(OAuth2HttpClient.access$getClock$p(oAuth2HttpClient)).plusSeconds(it.expiresIn()));
                OAuth2HttpClient.access$setAccessToken$p(oAuth2HttpClient, it.accessToken());
                return ((ResponseBody)t).accessToken();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"private fun refreshToken\u2026 .accessToken()\n        }");
        return completionStage;
    }

    private final HttpRequest buildAccessTokenRequest() {
        String credentials = this.clientId + ':' + this.clientSecret;
        Base64.Encoder encoder = Base64.getEncoder();
        String string = credentials;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        String encodedCredentials = encoder.encodeToString(byArray);
        return new HttpRequest.Builder().baseUrl(this.tokenUrl).method(HttpMethod.POST).putQueryParam("grant_type", "client_credentials").putHeader("Authorization", "Basic " + encodedCredentials).build();
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    private final void invalidateTokenUnsafe() {
        this.accessToken = null;
        this.tokenExpiresAt = null;
    }

    private final boolean isTokenExpired() {
        Instant instant = this.tokenExpiresAt;
        if (instant == null) {
            return true;
        }
        Instant expiresAt = instant;
        return Instant.now(this.clock).isAfter(expiresAt.minusSeconds(10L));
    }

    private static final CompletionStage executeAsync$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final HttpResponse executeAsync$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HttpResponse)$tmp0.invoke(p0);
    }

    private static final String refreshTokenUnsafeAsync$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    public static final /* synthetic */ HttpClient access$getHttpClient$p(OAuth2HttpClient $this) {
        return $this.httpClient;
    }

    public static final /* synthetic */ boolean access$isTokenExpired(OAuth2HttpClient $this) {
        return $this.isTokenExpired();
    }

    public static final /* synthetic */ String access$getAccessToken$p(OAuth2HttpClient $this) {
        return $this.accessToken;
    }

    public static final /* synthetic */ void access$invalidateTokenUnsafe(OAuth2HttpClient $this) {
        $this.invalidateTokenUnsafe();
    }

    public static final /* synthetic */ CompletableFuture access$refreshTokenUnsafeAsync(OAuth2HttpClient $this) {
        return $this.refreshTokenUnsafeAsync();
    }

    public static final /* synthetic */ HttpResponse.Handler access$getResponseBodyHandler$p(OAuth2HttpClient $this) {
        return $this.responseBodyHandler;
    }

    public static final /* synthetic */ HttpResponse.Handler access$getErrorHandler$p(OAuth2HttpClient $this) {
        return $this.errorHandler;
    }

    public static final /* synthetic */ void access$setTokenExpiresAt$p(OAuth2HttpClient $this, Instant instant) {
        $this.tokenExpiresAt = instant;
    }

    public static final /* synthetic */ Clock access$getClock$p(OAuth2HttpClient $this) {
        return $this.clock;
    }

    public static final /* synthetic */ void access$setAccessToken$p(OAuth2HttpClient $this, String string) {
        $this.accessToken = string;
    }

    public /* synthetic */ OAuth2HttpClient(HttpClient httpClient, String tokenUrl, String clientId, String clientSecret, JsonMapper jsonMapper, Clock clock, DefaultConstructorMarker $constructor_marker) {
        this(httpClient, tokenUrl, clientId, clientSecret, jsonMapper, clock);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/hiddenlayer/api/core/http/OAuth2HttpClient$Builder;", "", "()V", "clientId", "", "clientSecret", "clock", "Ljava/time/Clock;", "httpClient", "Lcom/hiddenlayer/api/core/http/HttpClient;", "jsonMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "tokenUrl", "build", "hiddenlayer-java-core"})
    @SourceDebugExtension(value={"SMAP\nOAuth2HttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuth2HttpClient.kt\ncom/hiddenlayer/api/core/http/OAuth2HttpClient$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1#2:200\n*E\n"})
    public static final class Builder {
        @Nullable
        private HttpClient httpClient;
        @Nullable
        private String tokenUrl;
        @Nullable
        private String clientId;
        @Nullable
        private String clientSecret;
        @Nullable
        private JsonMapper jsonMapper;
        @NotNull
        private Clock clock;

        public Builder() {
            Clock clock = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemUTC()");
            this.clock = clock;
        }

        @NotNull
        public final Builder httpClient(@NotNull HttpClient httpClient) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
            Builder $this$httpClient_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$httpClient_u24lambda_u240.httpClient = httpClient;
            return builder;
        }

        @NotNull
        public final Builder tokenUrl(@NotNull String tokenUrl) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tokenUrl, (String)"tokenUrl");
            Builder $this$tokenUrl_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$tokenUrl_u24lambda_u241.tokenUrl = tokenUrl;
            return builder;
        }

        @NotNull
        public final Builder clientId(@NotNull String clientId) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Builder $this$clientId_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$clientId_u24lambda_u242.clientId = clientId;
            return builder;
        }

        @NotNull
        public final Builder clientSecret(@NotNull String clientSecret) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
            Builder $this$clientSecret_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$clientSecret_u24lambda_u243.clientSecret = clientSecret;
            return builder;
        }

        @NotNull
        public final Builder jsonMapper(@NotNull JsonMapper jsonMapper) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)jsonMapper, (String)"jsonMapper");
            Builder $this$jsonMapper_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$jsonMapper_u24lambda_u244.jsonMapper = jsonMapper;
            return builder;
        }

        @NotNull
        public final Builder clock(@NotNull Clock clock) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            Builder $this$clock_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$clock_u24lambda_u245.clock = clock;
            return builder;
        }

        @NotNull
        public final HttpClient build() {
            return new OAuth2HttpClient(Check.checkRequired("httpClient", this.httpClient), Check.checkRequired("tokenUrl", this.tokenUrl), Check.checkRequired("clientId", this.clientId), Check.checkRequired("clientSecret", this.clientSecret), Check.checkRequired("jsonMapper", this.jsonMapper), this.clock, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/hiddenlayer/api/core/http/OAuth2HttpClient$Companion;", "", "()V", "builder", "Lcom/hiddenlayer/api/core/http/OAuth2HttpClient$Builder;", "hiddenlayer-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001B'\b\u0003\u0012\u000e\b\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0001\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0002\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0006R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/hiddenlayer/api/core/http/OAuth2HttpClient$ResponseBody;", "", "accessToken", "Lcom/hiddenlayer/api/core/JsonField;", "", "expiresIn", "", "(Lcom/hiddenlayer/api/core/JsonField;Lcom/hiddenlayer/api/core/JsonField;)V", "hiddenlayer-java-core"})
    private static final class ResponseBody {
        @NotNull
        private final JsonField<String> accessToken;
        @NotNull
        private final JsonField<Integer> expiresIn;

        @JsonCreator
        private ResponseBody(@JsonProperty(value="access_token") JsonField<String> accessToken, @JsonProperty(value="expires_in") JsonField<Integer> expiresIn) {
            this.accessToken = accessToken;
            this.expiresIn = expiresIn;
        }

        @NotNull
        public final String accessToken() {
            return (String)this.accessToken.getRequired$hiddenlayer_java_core("access_token");
        }

        public final int expiresIn() {
            return ((Number)this.expiresIn.getRequired$hiddenlayer_java_core("expires_in")).intValue();
        }
    }
}

