/*
 * Decompiled with CFR 0.152.
 */
package io.github.jopenlibs.vault.rest;

import io.github.jopenlibs.vault.rest.RestException;
import io.github.jopenlibs.vault.rest.RestResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.TreeMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;

public class Rest {
    private static SSLContext DISABLED_SSL_CONTEXT;
    private String urlString;
    private byte[] body;
    private final Map<String, String> parameters = new TreeMap<String, String>();
    private final Map<String, String> headers = new TreeMap<String, String>();
    private Integer connectTimeoutSeconds;
    private Integer readTimeoutSeconds;
    private Boolean sslVerification;
    private SSLContext sslContext;
    private final HttpClient configuredClient;

    public Rest(HttpClient configuredClient) {
        this.configuredClient = configuredClient;
    }

    public Rest() {
        this(null);
    }

    public Rest url(String urlString) {
        this.urlString = urlString;
        return this;
    }

    public Rest body(byte[] body) {
        this.body = body == null ? null : Arrays.copyOf(body, body.length);
        return this;
    }

    public Rest parameter(String name, String value) throws RestException {
        try {
            this.parameters.put(URLEncoder.encode(name, "UTF-8"), URLEncoder.encode(value, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RestException(e);
        }
        return this;
    }

    public Rest header(String name, String value) {
        if (value != null && !value.isEmpty()) {
            this.headers.put(name, value);
        }
        return this;
    }

    public Rest connectTimeoutSeconds(Integer connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
        return this;
    }

    public Rest readTimeoutSeconds(Integer readTimeoutSeconds) {
        this.readTimeoutSeconds = readTimeoutSeconds;
        return this;
    }

    public Rest sslVerification(Boolean sslVerification) {
        this.sslVerification = sslVerification;
        return this;
    }

    public Rest sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public RestResponse get() throws RestException {
        try {
            HttpRequest.Builder request = this.buildRequest(true);
            return this.send(request.GET().build());
        }
        catch (Exception e) {
            throw new RestException(e);
        }
    }

    public RestResponse post() throws RestException {
        return this.postOrPutImpl(true);
    }

    public RestResponse put() throws RestException {
        return this.postOrPutImpl(false);
    }

    public RestResponse delete() throws RestException {
        try {
            HttpRequest.Builder request = this.buildRequest(true);
            return this.send(request.DELETE().build());
        }
        catch (Exception e) {
            throw new RestException(e);
        }
    }

    private RestResponse postOrPutImpl(boolean doPost) throws RestException {
        try {
            HttpRequest.BodyPublisher payload;
            HttpRequest.Builder request = this.buildRequest(false);
            request.header("Accept-Charset", "UTF-8");
            if (this.body != null) {
                payload = HttpRequest.BodyPublishers.ofByteArray(this.body);
            } else if (!this.parameters.isEmpty()) {
                request.header("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                payload = HttpRequest.BodyPublishers.ofByteArray(this.parametersToQueryString().getBytes(StandardCharsets.UTF_8));
            } else {
                payload = HttpRequest.BodyPublishers.noBody();
            }
            if (doPost) {
                return this.send(request.POST(payload).build());
            }
            return this.send(request.PUT(payload).build());
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            throw new RestException(e);
        }
    }

    private String parametersToQueryString() {
        StringJoiner sj = new StringJoiner("&");
        this.parameters.forEach((name, value) -> sj.add(name + "=" + value));
        return sj.toString();
    }

    private RestResponse send(HttpRequest req) throws IOException, InterruptedException {
        HttpClient client = this.getClient();
        HttpResponse<String> response = client.send(req, HttpResponse.BodyHandlers.ofString());
        int statusCode = response.statusCode();
        String mimeType = response.headers().firstValue("Content-Type").orElse("");
        byte[] body = response.body().getBytes();
        return new RestResponse(statusCode, mimeType, body);
    }

    private HttpClient getClient() {
        if (this.configuredClient != null) {
            return this.configuredClient;
        }
        HttpClient.Builder client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1);
        if (this.connectTimeoutSeconds != null) {
            client.connectTimeout(Duration.of(this.connectTimeoutSeconds.intValue(), ChronoUnit.SECONDS));
        }
        if (this.sslVerification != null && !this.sslVerification.booleanValue()) {
            client.sslContext(DISABLED_SSL_CONTEXT);
        } else if (this.sslContext != null) {
            client.sslContext(this.sslContext);
        }
        return client.build();
    }

    private HttpRequest.Builder buildRequest(Boolean isGetOrDelete) throws URISyntaxException, RestException {
        Optional.ofNullable(this.urlString).orElseThrow(() -> new RestException("No URL is set"));
        URI uri = new URI(this.urlString);
        String params = isGetOrDelete != false ? this.parametersToQueryString() : "";
        Object query = params;
        if (uri.getQuery() != null) {
            query = uri.getQuery();
            if (!params.isEmpty()) {
                query = uri.getQuery() + "&" + params;
            }
        }
        uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), (String)query, uri.getFragment());
        HttpRequest.Builder request = HttpRequest.newBuilder().uri(uri);
        this.headers.forEach(request::header);
        if (this.readTimeoutSeconds != null) {
            request.timeout(Duration.of(this.readTimeoutSeconds.intValue(), ChronoUnit.SECONDS));
        }
        return request;
    }

    static {
        try {
            DISABLED_SSL_CONTEXT = SSLContext.getInstance("TLSv1.2");
            DISABLED_SSL_CONTEXT.init(null, new TrustManager[]{new X509ExtendedTrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}

