/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class VaultSecretValue
extends AbstractDescribableImpl<VaultSecretValue> {
    private String envVar;
    private boolean isRequired = DescriptorImpl.DEFAULT_IS_REQUIRED;
    private final String vaultKey;

    @Deprecated
    public VaultSecretValue(String envVar, @NonNull String vaultKey) {
        this.envVar = Util.fixEmptyAndTrim((String)envVar);
        this.vaultKey = Util.fixEmptyAndTrim((String)vaultKey);
    }

    @DataBoundConstructor
    public VaultSecretValue(@NonNull String vaultKey) {
        this.vaultKey = Util.fixEmptyAndTrim((String)vaultKey);
    }

    @DataBoundSetter
    public void setEnvVar(String envVar) {
        this.envVar = envVar;
    }

    @DataBoundSetter
    public void setIsRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public String getEnvVar() {
        return StringUtils.isEmpty((String)this.envVar) ? this.vaultKey : this.envVar;
    }

    public String getVaultKey() {
        return this.vaultKey;
    }

    public boolean getIsRequired() {
        return this.isRequired;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<VaultSecretValue> {
        public static final Boolean DEFAULT_IS_REQUIRED = true;

        public String getDisplayName() {
            return "Environment variable/vault secret value pair";
        }
    }
}

