/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.model;

import com.datapipe.jenkins.vault.configuration.VaultConfiguration;
import com.datapipe.jenkins.vault.model.VaultSecretValue;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.util.ListBoxModel;
import java.util.List;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class VaultSecret
extends AbstractDescribableImpl<VaultSecret> {
    private String path;
    private Integer engineVersion;
    private List<VaultSecretValue> secretValues;

    @DataBoundConstructor
    public VaultSecret(String path, List<VaultSecretValue> secretValues) {
        this.path = Util.fixEmptyAndTrim((String)path);
        this.secretValues = secretValues;
    }

    @DataBoundSetter
    public void setEngineVersion(Integer engineVersion) {
        this.engineVersion = engineVersion;
    }

    public String getPath() {
        return this.path;
    }

    public Integer getEngineVersion() {
        return this.engineVersion;
    }

    public List<VaultSecretValue> getSecretValues() {
        return this.secretValues;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<VaultSecret> {
        public String getDisplayName() {
            return "Vault Secret";
        }

        public ListBoxModel doFillEngineVersionItems(@AncestorInPath Item context) {
            return VaultConfiguration.engineVersions(context);
        }
    }
}

