/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.jcasc.secrets;

import com.datapipe.jenkins.vault.jcasc.secrets.VaultAuthenticatorWithExpiration;
import com.datapipe.jenkins.vault.jcasc.secrets.VaultUsernamePassword;
import io.github.jopenlibs.vault.Vault;
import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VaultUserPassAuthenticator
extends VaultAuthenticatorWithExpiration {
    private static final Logger LOGGER = Logger.getLogger(VaultUserPassAuthenticator.class.getName());
    private VaultUsernamePassword userPass;

    public VaultUserPassAuthenticator(VaultUsernamePassword userPass, String mountPath) {
        this.userPass = userPass;
        this.mountPath = mountPath;
    }

    @Override
    public void authenticate(Vault vault, VaultConfig config) throws VaultException {
        if (this.isTokenTTLExpired()) {
            this.currentAuthToken = vault.auth().loginByUserPass(this.userPass.getUsername(), this.userPass.getPassword(), this.mountPath).getAuthClientToken();
            config.token(this.currentAuthToken).build();
            LOGGER.log(Level.FINE, "Login to Vault using AppRole/SecretID successful");
            this.getTTLExpiryOfCurrentToken(vault);
        } else {
            config.token(this.currentAuthToken).build();
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.userPass, this.mountPath);
    }
}

