/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.jcasc.secrets;

import com.datapipe.jenkins.vault.exception.VaultPluginException;
import com.datapipe.jenkins.vault.jcasc.secrets.VaultAuthenticatorWithExpiration;
import com.datapipe.jenkins.vault.jcasc.secrets.VaultKubernetes;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.jopenlibs.vault.Vault;
import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VaultKubernetesAuthenticator
extends VaultAuthenticatorWithExpiration {
    private static final Logger LOGGER = Logger.getLogger(VaultKubernetesAuthenticator.class.getName());
    private static final String SERVICE_ACCOUNT_TOKEN_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    private VaultKubernetes kubernetes;
    private String mountPath;
    private String jwt;

    public VaultKubernetesAuthenticator(VaultKubernetes kubernetes, String mountPath) {
        this.kubernetes = kubernetes;
        this.mountPath = mountPath;
    }

    @Override
    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    public void authenticate(Vault vault, VaultConfig config) throws VaultException, VaultPluginException {
        if (this.isTokenTTLExpired()) {
            try (Stream<String> input = Files.lines(Paths.get(SERVICE_ACCOUNT_TOKEN_PATH, new String[0]));){
                this.jwt = input.collect(Collectors.joining());
            }
            catch (IOException e) {
                throw new VaultPluginException("could not get JWT from Service Account Token", e);
            }
            this.currentAuthToken = vault.auth().loginByJwt(this.mountPath, this.kubernetes.getRole(), this.jwt).getAuthClientToken();
            config.token(this.currentAuthToken).build();
            LOGGER.log(Level.FINE, "Login to Vault using Kubernetes successful");
            this.getTTLExpiryOfCurrentToken(vault);
        } else {
            config.token(this.currentAuthToken).build();
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.kubernetes);
    }
}

