/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.jcasc.secrets;

import com.datapipe.jenkins.vault.AwsHelper;
import com.datapipe.jenkins.vault.exception.VaultPluginException;
import com.datapipe.jenkins.vault.jcasc.secrets.VaultAuthenticatorWithExpiration;
import com.datapipe.jenkins.vault.jcasc.secrets.VaultAwsIam;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.github.jopenlibs.vault.Vault;
import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VaultAwsIamAuthenticator
extends VaultAuthenticatorWithExpiration {
    private static final Logger LOGGER = Logger.getLogger(VaultAwsIamAuthenticator.class.getName());
    @NonNull
    private VaultAwsIam awsIam;
    @NonNull
    private String mountPath;

    public VaultAwsIamAuthenticator(@NonNull VaultAwsIam awsIam, @NonNull String mountPath) {
        this.awsIam = awsIam;
        this.mountPath = mountPath;
    }

    @Override
    public void authenticate(@NonNull Vault vault, @NonNull VaultConfig config) throws VaultException, VaultPluginException {
        if (this.isTokenTTLExpired()) {
            this.currentAuthToken = AwsHelper.getToken(vault.auth(), null, this.awsIam.getRole(), this.awsIam.getServerId(), this.mountPath);
            config.token(this.currentAuthToken).build();
            LOGGER.log(Level.FINE, "Login to Vault using AWS IAM successful");
            this.getTTLExpiryOfCurrentToken(vault);
        } else {
            config.token(this.currentAuthToken).build();
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.awsIam);
    }
}

