/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.jcasc.secrets;

import com.datapipe.jenkins.vault.jcasc.secrets.VaultAuthenticator;
import io.github.jopenlibs.vault.Vault;
import io.github.jopenlibs.vault.VaultException;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class VaultAuthenticatorWithExpiration
implements VaultAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(VaultAuthenticatorWithExpiration.class.getName());
    protected String mountPath;
    private Calendar tokenExpiration;
    protected String currentAuthToken;

    VaultAuthenticatorWithExpiration() {
    }

    public boolean isTokenTTLExpired() {
        if (this.tokenExpiration == null) {
            return true;
        }
        boolean result = true;
        Calendar now = Calendar.getInstance();
        long timeDiffInMillis = now.getTimeInMillis() - this.tokenExpiration.getTimeInMillis();
        if (timeDiffInMillis < -2000L) {
            result = false;
            LOGGER.log(Level.FINE, "Auth token is still valid");
        } else {
            LOGGER.log(Level.FINE, "Auth token has to be re-issued" + timeDiffInMillis);
        }
        return result;
    }

    public void getTTLExpiryOfCurrentToken(Vault vault) {
        int tokenTTL = 0;
        try {
            tokenTTL = (int)vault.auth().lookupSelf().getTTL();
        }
        catch (VaultException e) {
            LOGGER.log(Level.WARNING, "Could not determine token expiration. Check if token is allowed to access auth/token/lookup-self. Assuming token TTL expired.", e);
        }
        this.tokenExpiration = Calendar.getInstance();
        this.tokenExpiration.add(13, tokenTTL);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VaultAuthenticatorWithExpiration authenticator = (VaultAuthenticatorWithExpiration)o;
        return this.hashCode() == authenticator.hashCode();
    }

    public int hashCode() {
        return super.hashCode();
    }
}

