/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.jcasc.secrets;

import com.datapipe.jenkins.vault.jcasc.secrets.VaultAppRole;
import com.datapipe.jenkins.vault.jcasc.secrets.VaultAppRoleAuthenticator;
import com.datapipe.jenkins.vault.jcasc.secrets.VaultAwsIam;
import com.datapipe.jenkins.vault.jcasc.secrets.VaultAwsIamAuthenticator;
import com.datapipe.jenkins.vault.jcasc.secrets.VaultKubernetes;
import com.datapipe.jenkins.vault.jcasc.secrets.VaultKubernetesAuthenticator;
import com.datapipe.jenkins.vault.jcasc.secrets.VaultSingleTokenAuthenticator;
import com.datapipe.jenkins.vault.jcasc.secrets.VaultUserPassAuthenticator;
import com.datapipe.jenkins.vault.jcasc.secrets.VaultUsernamePassword;
import io.github.jopenlibs.vault.Vault;
import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;

public interface VaultAuthenticator {
    public void authenticate(Vault var1, VaultConfig var2) throws VaultException;

    public static VaultAuthenticator of(String token) {
        return new VaultSingleTokenAuthenticator(token);
    }

    public static VaultAuthenticator of(VaultAppRole appRole, String mountPath) {
        return new VaultAppRoleAuthenticator(appRole, mountPath);
    }

    public static VaultAuthenticator of(VaultUsernamePassword vaultUsernamePassword, String mountPath) {
        return new VaultUserPassAuthenticator(vaultUsernamePassword, mountPath);
    }

    public static VaultAuthenticator of(VaultKubernetes vaultKubernetes, String mountPath) {
        return new VaultKubernetesAuthenticator(vaultKubernetes, mountPath);
    }

    public static VaultAuthenticator of(VaultAwsIam vaultAwsIam, String mountPath) {
        return new VaultAwsIamAuthenticator(vaultAwsIam, mountPath);
    }
}

