/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.jcasc.secrets;

import com.datapipe.jenkins.vault.jcasc.secrets.VaultAppRole;
import com.datapipe.jenkins.vault.jcasc.secrets.VaultAuthenticatorWithExpiration;
import io.github.jopenlibs.vault.Vault;
import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VaultAppRoleAuthenticator
extends VaultAuthenticatorWithExpiration {
    private static final Logger LOGGER = Logger.getLogger(VaultAppRoleAuthenticator.class.getName());
    private VaultAppRole appRole;

    public VaultAppRoleAuthenticator(VaultAppRole appRole, String mountPath) {
        this.appRole = appRole;
        this.mountPath = mountPath;
    }

    @Override
    public void authenticate(Vault vault, VaultConfig config) throws VaultException {
        if (this.isTokenTTLExpired()) {
            this.currentAuthToken = vault.auth().loginByAppRole(this.mountPath, this.appRole.getAppRole(), this.appRole.getAppRoleSecret()).getAuthClientToken();
            config.token(this.currentAuthToken).build();
            LOGGER.log(Level.FINE, "Login to Vault using AppRole/SecretID successful");
            this.getTTLExpiryOfCurrentToken(vault);
        } else {
            config.token(this.currentAuthToken).build();
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.appRole);
    }
}

