/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.credentials.common;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsSnapshotTaker;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.datapipe.jenkins.vault.configuration.VaultConfiguration;
import com.datapipe.jenkins.vault.credentials.common.AbstractVaultBaseStandardCredentials;
import com.datapipe.jenkins.vault.credentials.common.VaultHelper;
import com.datapipe.jenkins.vault.credentials.common.VaultUsernamePasswordCredential;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class VaultUsernamePasswordCredentialImpl
extends AbstractVaultBaseStandardCredentials
implements VaultUsernamePasswordCredential {
    public static final String DEFAULT_USERNAME_KEY = "username";
    public static final String DEFAULT_PASSWORD_KEY = "password";
    private static final long serialVersionUID = 1L;
    private String usernameKey;
    private String passwordKey;

    @DataBoundConstructor
    public VaultUsernamePasswordCredentialImpl(CredentialsScope scope, String id, String description) {
        super(scope, id, description);
    }

    @NonNull
    public String getUsernameKey() {
        return this.usernameKey;
    }

    @DataBoundSetter
    public void setUsernameKey(String usernameKey) {
        this.usernameKey = StringUtils.defaultIfBlank((String)usernameKey, (String)DEFAULT_USERNAME_KEY);
    }

    @NonNull
    public String getPasswordKey() {
        return this.passwordKey;
    }

    @DataBoundSetter
    public void setPasswordKey(String passwordKey) {
        this.passwordKey = StringUtils.defaultIfBlank((String)passwordKey, (String)DEFAULT_PASSWORD_KEY);
    }

    @NonNull
    public String getUsername() {
        String secretKey = StringUtils.defaultIfBlank((String)this.usernameKey, (String)DEFAULT_USERNAME_KEY);
        return this.getVaultSecretKeyValue(secretKey);
    }

    @NonNull
    public Secret getPassword() {
        String secretKey = StringUtils.defaultIfBlank((String)this.passwordKey, (String)DEFAULT_PASSWORD_KEY);
        String secret = this.getVaultSecretKeyValue(secretKey);
        return Secret.fromString((String)secret);
    }

    @Extension
    public static class SnapshotTaker
    extends CredentialsSnapshotTaker<VaultUsernamePasswordCredentialImpl> {
        public Class<VaultUsernamePasswordCredentialImpl> type() {
            return VaultUsernamePasswordCredentialImpl.class;
        }

        public VaultUsernamePasswordCredentialImpl snapshot(VaultUsernamePasswordCredentialImpl credentials) {
            return new SelfContained(credentials);
        }
    }

    static class SelfContained
    extends VaultUsernamePasswordCredentialImpl {
        private final String username;
        private final Secret password;

        public SelfContained(VaultUsernamePasswordCredentialImpl base) {
            super(base.getScope(), base.getId(), base.getDescription());
            this.username = base.getUsername();
            this.password = base.getPassword();
        }

        @Override
        @NonNull
        public String getUsername() {
            return this.username;
        }

        @Override
        @NonNull
        public Secret getPassword() {
            return this.password;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "Vault Username-Password Credential";
        }

        public FormValidation doTestConnection(@AncestorInPath ItemGroup<Item> context, @QueryParameter(value="path") String path, @QueryParameter(value="usernameKey") String usernameKey, @QueryParameter(value="passwordKey") String passwordKey, @QueryParameter(value="prefixPath") String prefixPath, @QueryParameter(value="namespace") String namespace, @QueryParameter(value="engineVersion") Integer engineVersion) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String username = null;
            try {
                username = VaultHelper.getVaultSecretKey(path, StringUtils.defaultIfBlank((String)usernameKey, (String)VaultUsernamePasswordCredentialImpl.DEFAULT_USERNAME_KEY), prefixPath, namespace, engineVersion, context);
            }
            catch (Exception e) {
                return FormValidation.error((String)("FAILED to retrieve username key: \n" + String.valueOf(e)));
            }
            try {
                VaultHelper.getVaultSecretKey(path, StringUtils.defaultIfBlank((String)passwordKey, (String)VaultUsernamePasswordCredentialImpl.DEFAULT_PASSWORD_KEY), prefixPath, namespace, engineVersion, context);
            }
            catch (Exception e) {
                return FormValidation.error((String)("FAILED to retrieve password key: \n" + String.valueOf(e)));
            }
            return FormValidation.ok((String)("Successfully retrieved username " + username + " and the password"));
        }

        public ListBoxModel doFillEngineVersionItems(@AncestorInPath Item context) {
            return VaultConfiguration.engineVersions(context);
        }
    }
}

