/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.credentials.common;

import com.datapipe.jenkins.vault.configuration.VaultConfiguration;
import com.datapipe.jenkins.vault.credentials.common.VaultUsernamePasswordCredential;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;

public class VaultUsernamePasswordCredentialBinding
extends MultiBinding<VaultUsernamePasswordCredential> {
    public static final String DEFAULT_USERNAME_VARIABLE = "USERNAME";
    public static final String DEFAULT_PASSWORD_VARIABLE = "PASSWORD";
    private String usernameVariable;
    private String passwordVariable;

    @DataBoundConstructor
    public VaultUsernamePasswordCredentialBinding(@Nullable String usernameVariable, @Nullable String passwordVariable, String credentialsId) {
        super(credentialsId);
        this.usernameVariable = StringUtils.defaultIfBlank((String)usernameVariable, (String)DEFAULT_USERNAME_VARIABLE);
        this.passwordVariable = StringUtils.defaultIfBlank((String)passwordVariable, (String)DEFAULT_PASSWORD_VARIABLE);
    }

    protected Class<VaultUsernamePasswordCredential> type() {
        return VaultUsernamePasswordCredential.class;
    }

    public MultiBinding.MultiEnvironment bind(@NonNull Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        VaultUsernamePasswordCredential credentials = (VaultUsernamePasswordCredential)this.getCredentials(build);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(this.usernameVariable, credentials.getUsername());
        map.put(this.passwordVariable, credentials.getPassword().getPlainText());
        return new MultiBinding.MultiEnvironment(map);
    }

    public String getUsernameVariable() {
        return this.usernameVariable;
    }

    public String getPasswordVariable() {
        return this.passwordVariable;
    }

    public Set<String> variables() {
        HashSet<String> variables = new HashSet<String>();
        variables.add(this.usernameVariable);
        variables.add(this.passwordVariable);
        return variables;
    }

    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<VaultUsernamePasswordCredential> {
        protected Class<VaultUsernamePasswordCredential> type() {
            return VaultUsernamePasswordCredential.class;
        }

        public String getDisplayName() {
            return "Vault Username-Password Credentials";
        }

        public ListBoxModel doFillEngineVersionItems(@AncestorInPath Item context) {
            return VaultConfiguration.engineVersions(context);
        }
    }
}

