/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.credentials.common;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsSnapshotTaker;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.datapipe.jenkins.vault.configuration.VaultConfiguration;
import com.datapipe.jenkins.vault.credentials.common.AbstractVaultBaseStandardCredentials;
import com.datapipe.jenkins.vault.credentials.common.VaultHelper;
import com.datapipe.jenkins.vault.credentials.common.VaultStringCredential;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class VaultStringCredentialImpl
extends AbstractVaultBaseStandardCredentials
implements VaultStringCredential {
    public static final String DEFAULT_VAULT_KEY = "secret";
    private static final long serialVersionUID = 1L;
    private String vaultKey;

    @DataBoundConstructor
    public VaultStringCredentialImpl(CredentialsScope scope, String id, String description) {
        super(scope, id, description);
    }

    @NonNull
    public String getVaultKey() {
        return this.vaultKey;
    }

    @DataBoundSetter
    public void setVaultKey(String vaultKey) {
        this.vaultKey = StringUtils.defaultIfBlank((String)vaultKey, (String)DEFAULT_VAULT_KEY);
    }

    @NonNull
    public Secret getSecret() {
        String k = StringUtils.defaultIfBlank((String)this.vaultKey, (String)DEFAULT_VAULT_KEY);
        String s = this.getVaultSecretKeyValue(k);
        return Secret.fromString((String)s);
    }

    @Extension
    public static class SnapshotTaker
    extends CredentialsSnapshotTaker<VaultStringCredentialImpl> {
        public Class<VaultStringCredentialImpl> type() {
            return VaultStringCredentialImpl.class;
        }

        public VaultStringCredentialImpl snapshot(VaultStringCredentialImpl credentials) {
            return new SelfContained(credentials);
        }
    }

    static class SelfContained
    extends VaultStringCredentialImpl {
        private final Secret secret;

        public SelfContained(VaultStringCredentialImpl base) {
            super(base.getScope(), base.getId(), base.getDescription());
            this.secret = base.getSecret();
        }

        @Override
        @NonNull
        public Secret getSecret() {
            return this.secret;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "Vault Secret Text Credential";
        }

        public FormValidation doTestConnection(@AncestorInPath ItemGroup<Item> context, @QueryParameter(value="path") String path, @QueryParameter(value="vaultKey") String vaultKey, @QueryParameter(value="prefixPath") String prefixPath, @QueryParameter(value="namespace") String namespace, @QueryParameter(value="engineVersion") Integer engineVersion) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                VaultHelper.getVaultSecretKey(path, StringUtils.defaultIfBlank((String)vaultKey, (String)VaultStringCredentialImpl.DEFAULT_VAULT_KEY), prefixPath, namespace, engineVersion, context);
            }
            catch (Exception e) {
                return FormValidation.error((String)("FAILED to retrieve Vault secret: \n" + String.valueOf(e)));
            }
            return FormValidation.ok((String)("Successfully retrieved secret by key " + vaultKey));
        }

        public ListBoxModel doFillEngineVersionItems(@AncestorInPath Item context) {
            return VaultConfiguration.engineVersions(context);
        }
    }
}

