/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.credentials.common;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsSnapshotTaker;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.datapipe.jenkins.vault.configuration.VaultConfiguration;
import com.datapipe.jenkins.vault.credentials.common.AbstractVaultBaseStandardCredentials;
import com.datapipe.jenkins.vault.credentials.common.VaultHelper;
import com.datapipe.jenkins.vault.credentials.common.VaultSSHUserPrivateKey;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class VaultSSHUserPrivateKeyImpl
extends AbstractVaultBaseStandardCredentials
implements VaultSSHUserPrivateKey {
    private static final Logger LOGGER = Logger.getLogger(VaultSSHUserPrivateKeyImpl.class.getName());
    public static final String DEFAULT_USERNAME_KEY = "username";
    public static final String DEFAULT_PRIVATE_KEY_KEY = "private_key";
    public static final String DEFAULT_PASSPHRASE_KEY = "passphrase";
    private static final long serialVersionUID = 1L;
    private String usernameKey;
    private String privateKeyKey;
    private String passphraseKey;

    @DataBoundConstructor
    public VaultSSHUserPrivateKeyImpl(CredentialsScope scope, String id, String description) {
        super(scope, id, description);
    }

    @NonNull
    public String getUsernameKey() {
        return this.usernameKey;
    }

    @DataBoundSetter
    public void setUsernameKey(String usernameKey) {
        this.usernameKey = StringUtils.defaultIfBlank((String)usernameKey, (String)DEFAULT_USERNAME_KEY);
    }

    @NonNull
    public String getPrivateKeyKey() {
        return this.privateKeyKey;
    }

    @DataBoundSetter
    public void setPrivateKeyKey(String privateKeyKey) {
        this.privateKeyKey = StringUtils.defaultIfBlank((String)privateKeyKey, (String)DEFAULT_PRIVATE_KEY_KEY);
    }

    @NonNull
    public String getPassphraseKey() {
        return this.passphraseKey;
    }

    @DataBoundSetter
    public void setPassphraseKey(String passphraseKey) {
        this.passphraseKey = StringUtils.defaultIfBlank((String)passphraseKey, (String)DEFAULT_PASSPHRASE_KEY);
    }

    @NonNull
    public String getUsername() {
        String secretKey = StringUtils.defaultIfBlank((String)this.usernameKey, (String)DEFAULT_USERNAME_KEY);
        return this.getVaultSecretKeyValue(secretKey);
    }

    @NonNull
    public String getPrivateKey() {
        String secretKey = StringUtils.defaultIfBlank((String)this.privateKeyKey, (String)DEFAULT_PRIVATE_KEY_KEY);
        return this.getVaultSecretKeyValue(secretKey);
    }

    @NonNull
    public List<String> getPrivateKeys() {
        String key = this.getPrivateKey();
        return Collections.singletonList(key.endsWith("\n") ? key : key + "\n");
    }

    @NonNull
    public Secret getPassphrase() {
        String secretKey = StringUtils.defaultIfBlank((String)this.passphraseKey, (String)DEFAULT_PASSPHRASE_KEY);
        String secret = this.getVaultSecretKeyValue(secretKey);
        return Secret.fromString((String)secret);
    }

    @Extension
    public static class SnapshotTaker
    extends CredentialsSnapshotTaker<VaultSSHUserPrivateKeyImpl> {
        public Class<VaultSSHUserPrivateKeyImpl> type() {
            return VaultSSHUserPrivateKeyImpl.class;
        }

        public VaultSSHUserPrivateKeyImpl snapshot(VaultSSHUserPrivateKeyImpl credentials) {
            return new SelfContained(credentials);
        }
    }

    static class SelfContained
    extends VaultSSHUserPrivateKeyImpl {
        private final String username;
        private final String privateKey;
        private final Secret passphrase;

        public SelfContained(VaultSSHUserPrivateKeyImpl base) {
            super(base.getScope(), base.getId(), base.getDescription());
            this.username = base.getUsername();
            this.privateKey = base.getPrivateKey();
            this.passphrase = base.getPassphrase();
        }

        @Override
        @NonNull
        public String getUsername() {
            return this.username;
        }

        @Override
        @NonNull
        public String getPrivateKey() {
            return this.privateKey;
        }

        @Override
        @NonNull
        public Secret getPassphrase() {
            return this.passphrase;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "Vault SSH Username with private key Credential";
        }

        public FormValidation doTestConnection(@AncestorInPath ItemGroup<Item> context, @QueryParameter(value="path") String path, @QueryParameter(value="usernameKey") String usernameKey, @QueryParameter(value="privateKeyKey") String privateKeyKey, @QueryParameter(value="passphraseKey") String passphraseKey, @QueryParameter(value="prefixPath") String prefixPath, @QueryParameter(value="namespace") String namespace, @QueryParameter(value="engineVersion") Integer engineVersion) {
            String username;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                username = VaultHelper.getVaultSecretKey(path, StringUtils.defaultIfBlank((String)usernameKey, (String)VaultSSHUserPrivateKeyImpl.DEFAULT_USERNAME_KEY), prefixPath, namespace, engineVersion, context);
            }
            catch (Exception e) {
                return FormValidation.error((String)("FAILED to retrieve username key: \n" + String.valueOf(e)));
            }
            try {
                VaultHelper.getVaultSecretKey(path, StringUtils.defaultIfBlank((String)privateKeyKey, (String)VaultSSHUserPrivateKeyImpl.DEFAULT_PRIVATE_KEY_KEY), prefixPath, namespace, engineVersion, context);
            }
            catch (Exception e) {
                return FormValidation.error((String)("FAILED to retrieve private key key: \n" + String.valueOf(e)));
            }
            try {
                VaultHelper.getVaultSecretKey(path, StringUtils.defaultIfBlank((String)passphraseKey, (String)VaultSSHUserPrivateKeyImpl.DEFAULT_PASSPHRASE_KEY), prefixPath, namespace, engineVersion, context);
            }
            catch (Exception e) {
                return FormValidation.error((String)("FAILED to retrieve passphrase key: \n" + String.valueOf(e)));
            }
            return FormValidation.ok((String)String.format("Successfully retrieved username %s, the private key and the passphrase", username));
        }

        public ListBoxModel doFillEngineVersionItems(@AncestorInPath Item context) {
            return VaultConfiguration.engineVersions(context);
        }
    }
}

