/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.credentials.common;

import com.datapipe.jenkins.vault.WindowsFilePermissionHelper;
import com.datapipe.jenkins.vault.configuration.VaultConfiguration;
import com.datapipe.jenkins.vault.credentials.common.VaultSSHUserPrivateKey;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.UnbindableDir;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;

public class VaultSSHUserPrivateKeyBinding
extends MultiBinding<VaultSSHUserPrivateKey> {
    public static final String DEFAULT_USERNAME_VARIABLE = "USERNAME";
    public static final String DEFAULT_PRIVATE_KEY_VARIABLE = "PRIVATE_KEY";
    public static final String DEFAULT_PASSPHRASE_VARIABLE = "PASSPHRASE";
    private final String privateKeyVariable;
    private final String usernameVariable;
    private final String passphraseVariable;

    @DataBoundConstructor
    public VaultSSHUserPrivateKeyBinding(@Nullable String usernameVariable, @Nullable String privateKeyVariable, @Nullable String passphraseVariable, String credentialsId) {
        super(credentialsId);
        this.usernameVariable = StringUtils.defaultIfBlank((String)usernameVariable, (String)DEFAULT_USERNAME_VARIABLE);
        this.privateKeyVariable = StringUtils.defaultIfBlank((String)privateKeyVariable, (String)DEFAULT_PRIVATE_KEY_VARIABLE);
        this.passphraseVariable = StringUtils.defaultIfBlank((String)passphraseVariable, (String)DEFAULT_PASSPHRASE_VARIABLE);
    }

    protected Class<VaultSSHUserPrivateKey> type() {
        return VaultSSHUserPrivateKey.class;
    }

    public Set<String> variables() {
        HashSet<String> set = new HashSet<String>();
        set.add(this.privateKeyVariable);
        set.add(this.usernameVariable);
        set.add(this.passphraseVariable);
        return ImmutableSet.copyOf(set);
    }

    public MultiBinding.MultiEnvironment bind(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        VaultSSHUserPrivateKey sshKey = (VaultSSHUserPrivateKey)this.getCredentials(build);
        UnbindableDir keyDir = UnbindableDir.create((FilePath)workspace);
        FilePath keyFile = keyDir.getDirPath().child(String.format("ssh-key-%s", this.privateKeyVariable));
        StringBuilder contents = new StringBuilder();
        for (String key : sshKey.getPrivateKeys()) {
            contents.append(key);
        }
        keyFile.write(contents.toString(), "UTF-8");
        if (launcher.isUnix()) {
            keyFile.chmod(256);
        } else {
            WindowsFilePermissionHelper.fixSshKeyOnWindows(Paths.get(keyFile.toURI()));
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(this.privateKeyVariable, keyFile.getRemote());
        if (this.passphraseVariable != null) {
            Secret passphrase = sshKey.getPassphrase();
            if (passphrase != null) {
                map.put(this.passphraseVariable, passphrase.getPlainText());
            } else {
                map.put(this.passphraseVariable, "");
            }
        }
        if (this.usernameVariable != null) {
            map.put(this.usernameVariable, sshKey.getUsername());
        }
        return new MultiBinding.MultiEnvironment(map, keyDir.getUnbinder());
    }

    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<VaultSSHUserPrivateKey> {
        protected Class<VaultSSHUserPrivateKey> type() {
            return VaultSSHUserPrivateKey.class;
        }

        public String getDisplayName() {
            return "Vault SSH Username with private key Credentials";
        }

        public ListBoxModel doFillEngineVersionItems(@AncestorInPath Item context) {
            return VaultConfiguration.engineVersions(context);
        }
    }
}

