/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.credentials.common;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.datapipe.jenkins.vault.configuration.VaultConfiguration;
import com.datapipe.jenkins.vault.credentials.common.AbstractVaultBaseStandardCredentials;
import com.datapipe.jenkins.vault.credentials.common.VaultGCRLogin;
import com.datapipe.jenkins.vault.credentials.common.VaultHelper;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class VaultGCRLoginImpl
extends AbstractVaultBaseStandardCredentials
implements VaultGCRLogin {
    private static final Logger LOGGER = Logger.getLogger(VaultGCRLoginImpl.class.getName());

    @DataBoundConstructor
    public VaultGCRLoginImpl(CredentialsScope scope, String id, String description) {
        super(scope, id, description);
    }

    @Override
    public String getDisplayName() {
        return "Vault Google Container Registry Login";
    }

    @NonNull
    public Secret getPassword() {
        Map<String, String> s = this.getVaultSecretValue();
        String key = JSONObject.fromObject(s).toString();
        return Secret.fromString((String)key);
    }

    @NonNull
    public String getUsername() {
        return "_json_key";
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "Vault Google Container Registry Login";
        }

        public FormValidation doTestConnection(@AncestorInPath ItemGroup<Item> context, @QueryParameter(value="path") String path, @QueryParameter(value="prefixPath") String prefixPath, @QueryParameter(value="namespace") String namespace, @QueryParameter(value="engineVersion") Integer engineVersion) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String okMessage = "Successfully retrieved secret " + path;
            try {
                VaultHelper.getVaultSecret(path, prefixPath, namespace, engineVersion, context);
            }
            catch (Exception e) {
                return FormValidation.error((String)("FAILED to retrieve Vault secret: \n" + String.valueOf(e)));
            }
            return FormValidation.ok((String)okMessage);
        }

        public ListBoxModel doFillEngineVersionItems(@AncestorInPath Item context) {
            return VaultConfiguration.engineVersions(context);
        }
    }
}

