/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.credentials.common;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.datapipe.jenkins.vault.configuration.VaultConfiguration;
import com.datapipe.jenkins.vault.credentials.common.AbstractVaultBaseStandardCredentials;
import com.datapipe.jenkins.vault.credentials.common.VaultFileCredential;
import com.datapipe.jenkins.vault.credentials.common.VaultHelper;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class VaultFileCredentialImpl
extends AbstractVaultBaseStandardCredentials
implements VaultFileCredential {
    private static final long serialVersionUID = 1L;
    private String fileName = UUID.randomUUID().toString();
    private Boolean useKey;
    private String vaultKey;

    @DataBoundConstructor
    public VaultFileCredentialImpl(CredentialsScope scope, String id, String description) {
        super(scope, id, description);
    }

    @NonNull
    public String getVaultKey() {
        return this.vaultKey;
    }

    @DataBoundSetter
    public void setVaultKey(String vaultKey) {
        this.vaultKey = vaultKey;
    }

    @NonNull
    public Boolean getUseKey() {
        return this.useKey;
    }

    @DataBoundSetter
    public void setUseKey(Boolean useKey) {
        this.useKey = useKey;
    }

    @NonNull
    public String getFileName() {
        return this.fileName;
    }

    @NonNull
    public InputStream getContent() {
        String content;
        if (this.useKey != null && this.useKey.booleanValue()) {
            content = this.getVaultSecretKeyValue(this.vaultKey);
        } else {
            Map<String, String> s = this.getVaultSecretValue();
            content = JSONObject.fromObject(s).toString();
        }
        return new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "Vault Secret File Credential";
        }

        public FormValidation doTestConnection(@AncestorInPath ItemGroup<Item> context, @QueryParameter(value="path") String path, @QueryParameter(value="useKey") Boolean useKey, @QueryParameter(value="vaultKey") String vaultKey, @QueryParameter(value="prefixPath") String prefixPath, @QueryParameter(value="namespace") String namespace, @QueryParameter(value="engineVersion") Integer engineVersion) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String okMessage = "Successfully retrieved secret " + path;
            if (useKey.booleanValue()) {
                try {
                    VaultHelper.getVaultSecretKey(path, vaultKey, prefixPath, namespace, engineVersion, context);
                }
                catch (Exception e) {
                    return FormValidation.error((String)("FAILED to retrieve key '" + vaultKey + "' Vault secret: \n" + String.valueOf(e)));
                }
                okMessage = okMessage + " with key " + vaultKey;
            } else {
                try {
                    VaultHelper.getVaultSecret(path, prefixPath, namespace, engineVersion, context);
                }
                catch (Exception e) {
                    return FormValidation.error((String)("FAILED to retrieve Vault secret: \n" + String.valueOf(e)));
                }
            }
            return FormValidation.ok((String)okMessage);
        }

        public ListBoxModel doFillEngineVersionItems(@AncestorInPath Item context) {
            return VaultConfiguration.engineVersions(context);
        }
    }
}

