/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.credentials.common;

import com.datapipe.jenkins.vault.credentials.common.VaultFileCredential;
import hudson.Extension;
import hudson.FilePath;
import java.io.IOException;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.impl.AbstractOnDiskBinding;
import org.kohsuke.stapler.DataBoundConstructor;

public class VaultFileCredentialBinding
extends AbstractOnDiskBinding<VaultFileCredential> {
    @DataBoundConstructor
    public VaultFileCredentialBinding(String variable, String credentialsId) {
        super(variable, credentialsId);
    }

    protected Class<VaultFileCredential> type() {
        return VaultFileCredential.class;
    }

    protected final FilePath write(VaultFileCredential credentials, FilePath dir) throws IOException, InterruptedException {
        FilePath secret = dir.child(credentials.getFileName());
        secret.copyFrom(credentials.getContent());
        secret.chmod(448);
        return secret;
    }

    @Symbol(value={"vaultFile"})
    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<VaultFileCredential> {
        public boolean requiresWorkspace() {
            return true;
        }

        protected Class<VaultFileCredential> type() {
            return VaultFileCredential.class;
        }

        public String getDisplayName() {
            return "Vault Secret File Credential";
        }
    }
}

