/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.credentials.common;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.datapipe.jenkins.vault.configuration.VaultConfiguration;
import com.datapipe.jenkins.vault.credentials.common.AbstractVaultBaseStandardCredentials;
import com.datapipe.jenkins.vault.credentials.common.VaultCertificateCredentials;
import com.datapipe.jenkins.vault.credentials.common.VaultHelper;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class VaultCertificateCredentialsImpl
extends AbstractVaultBaseStandardCredentials
implements VaultCertificateCredentials {
    private static final Logger LOGGER = Logger.getLogger(VaultCertificateCredentialsImpl.class.getName());
    private static final long serialVersionUID = 1L;
    private String keyStoreKey;
    private String passwordKey;

    @DataBoundConstructor
    public VaultCertificateCredentialsImpl(CredentialsScope scope, String id, String description) {
        super(scope, id, description);
    }

    @NonNull
    public String getKeyStoreKeyKey() {
        return this.keyStoreKey;
    }

    @DataBoundSetter
    public void setKeyStoreKey(String keyStoreKey) {
        this.keyStoreKey = StringUtils.defaultIfBlank((String)keyStoreKey, (String)"keystore");
    }

    @NonNull
    public String getPasswordKey() {
        return this.passwordKey;
    }

    @DataBoundSetter
    public void setPasswordKey(String passwordKey) {
        this.passwordKey = StringUtils.defaultIfBlank((String)passwordKey, (String)"password");
    }

    @NonNull
    public KeyStore getKeyStore() {
        KeyStore keyStore;
        String secretKey = StringUtils.defaultIfBlank((String)this.keyStoreKey, (String)"keystore");
        String base64KeyStore = this.getVaultSecretKeyValue(secretKey);
        try {
            keyStore = KeyStore.getInstance("PKCS12");
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("PKCS12 is a keystore type per the JLS spec", e);
        }
        try {
            keyStore.load(new ByteArrayInputStream(Base64.getDecoder().decode(VaultCertificateCredentialsImpl.unwrap(base64KeyStore))), VaultCertificateCredentialsImpl.toCharArray(this.getPassword()));
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            LogRecord lr = new LogRecord(Level.WARNING, "Credentials ID {0}: Could not load keystore from Vault");
            lr.setParameters(new Object[]{this.getId()});
            lr.setThrown(e);
            LOGGER.log(lr);
        }
        return keyStore;
    }

    @NonNull
    public Secret getPassword() {
        String secretKey = StringUtils.defaultIfBlank((String)this.passwordKey, (String)"password");
        String secret = this.getVaultSecretKeyValue(secretKey);
        return Secret.fromString((String)secret);
    }

    @Override
    public void write(FilePath keyStoreFile) throws IOException {
        try {
            this.getKeyStore().store(keyStoreFile.write(), VaultCertificateCredentialsImpl.toCharArray(this.getPassword()));
        }
        catch (InterruptedException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LogRecord lr = new LogRecord(Level.WARNING, "Credentials ID {0}: Could not write keystore to file");
            lr.setParameters(new Object[]{this.getId()});
            lr.setThrown(e);
            LOGGER.log(lr);
        }
    }

    @CheckForNull
    private static char[] toCharArray(@NonNull Secret password) {
        String plainText = Util.fixEmpty((String)password.getPlainText());
        return plainText == null ? null : plainText.toCharArray();
    }

    @CheckForNull
    private static String unwrap(@NonNull String wrapped) {
        return wrapped == null ? null : Pattern.compile("\\r?\\n").matcher(wrapped).replaceAll("");
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public static final String DEFAULT_KEYSTORE_KEY = "keystore";
        public static final String DEFAULT_PASSWORD_KEY = "password";

        public String getDisplayName() {
            return "Vault Certificate Credential";
        }

        public FormValidation doTestConnection(@AncestorInPath ItemGroup<Item> context, @QueryParameter(value="path") String path, @QueryParameter(value="keyStoreKey") String keyStoreKey, @QueryParameter(value="passwordKey") String passwordKey, @QueryParameter(value="prefixPath") String prefixPath, @QueryParameter(value="namespace") String namespace, @QueryParameter(value="engineVersion") Integer engineVersion) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                VaultHelper.getVaultSecretKey(path, StringUtils.defaultIfBlank((String)keyStoreKey, (String)DEFAULT_KEYSTORE_KEY), prefixPath, namespace, engineVersion, context);
            }
            catch (Exception e) {
                return FormValidation.error((String)("FAILED to retrieve keyStore key: \n" + String.valueOf(e)));
            }
            try {
                VaultHelper.getVaultSecretKey(path, StringUtils.defaultIfBlank((String)passwordKey, (String)DEFAULT_PASSWORD_KEY), prefixPath, namespace, engineVersion, context);
            }
            catch (Exception e) {
                return FormValidation.error((String)("FAILED to retrieve password key: \n" + String.valueOf(e)));
            }
            return FormValidation.ok((String)"Successfully retrieved keyStore and the password");
        }

        public ListBoxModel doFillEngineVersionItems(@AncestorInPath Item context) {
            return VaultConfiguration.engineVersions(context);
        }
    }
}

