/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.credentials.common;

import com.datapipe.jenkins.vault.configuration.VaultConfiguration;
import com.datapipe.jenkins.vault.credentials.common.VaultCertificateCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.UnbindableDir;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;

public class VaultCertificateCredentialsBinding
extends MultiBinding<VaultCertificateCredentials> {
    public static final String DEFAULT_KEYSTORE_VARIABLE = "KEYSTORE";
    public static final String DEFAULT_PASSWORD_VARIABLE = "PASSWORD";
    private String keyStoreVariable;
    private String passwordVariable;

    @DataBoundConstructor
    public VaultCertificateCredentialsBinding(@Nullable String keyStoreVariable, @Nullable String passwordVariable, String credentialsId) {
        super(credentialsId);
        this.keyStoreVariable = StringUtils.defaultIfBlank((String)keyStoreVariable, (String)DEFAULT_KEYSTORE_VARIABLE);
        this.passwordVariable = StringUtils.defaultIfBlank((String)passwordVariable, (String)DEFAULT_PASSWORD_VARIABLE);
    }

    protected Class<VaultCertificateCredentials> type() {
        return VaultCertificateCredentials.class;
    }

    public MultiBinding.MultiEnvironment bind(@NonNull Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        VaultCertificateCredentials credentials = (VaultCertificateCredentials)this.getCredentials(build);
        UnbindableDir keyStoreDir = UnbindableDir.create((FilePath)workspace);
        FilePath keyStoreFile = keyStoreDir.getDirPath().child(String.format("keystore-%s", this.keyStoreVariable));
        credentials.write(keyStoreFile);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(this.keyStoreVariable, keyStoreFile.getRemote());
        map.put(this.passwordVariable, credentials.getPassword().getPlainText());
        return new MultiBinding.MultiEnvironment(map);
    }

    public String getKeyStoreVariable() {
        return this.keyStoreVariable;
    }

    public String getPasswordVariable() {
        return this.passwordVariable;
    }

    public Set<String> variables() {
        HashSet<String> variables = new HashSet<String>();
        variables.add(this.keyStoreVariable);
        variables.add(this.passwordVariable);
        return variables;
    }

    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<VaultCertificateCredentials> {
        protected Class<VaultCertificateCredentials> type() {
            return VaultCertificateCredentials.class;
        }

        public String getDisplayName() {
            return "Vault KeyStore-Password Credentials";
        }

        public ListBoxModel doFillEngineVersionItems(@AncestorInPath Item context) {
            return VaultConfiguration.engineVersions(context);
        }
    }
}

