/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.credentials.common;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.datapipe.jenkins.vault.credentials.common.VaultHelper;
import com.datapipe.jenkins.vault.exception.VaultPluginException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.Item;
import hudson.model.ItemGroup;
import java.util.Map;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class AbstractVaultBaseStandardCredentials
extends BaseStandardCredentials {
    private String path;
    private String prefixPath;
    private String namespace;
    private Integer engineVersion;
    private transient ItemGroup context;

    AbstractVaultBaseStandardCredentials(CredentialsScope scope, String id, String description) {
        super(scope, id, description);
    }

    @NonNull
    public String getPrefixPath() {
        return this.prefixPath;
    }

    @DataBoundSetter
    public void setPrefixPath(String prefixPath) {
        this.prefixPath = Util.fixEmptyAndTrim((String)prefixPath);
    }

    @NonNull
    public String getPath() {
        return this.path;
    }

    @DataBoundSetter
    public void setPath(String path) {
        this.path = path;
    }

    @CheckForNull
    public String getNamespace() {
        return this.namespace;
    }

    @DataBoundSetter
    public void setNamespace(String namespace) {
        this.namespace = Util.fixEmptyAndTrim((String)namespace);
    }

    @CheckForNull
    public Integer getEngineVersion() {
        return this.engineVersion;
    }

    @DataBoundSetter
    public void setEngineVersion(Integer engineVersion) {
        this.engineVersion = engineVersion;
    }

    public void setContext(@NonNull ItemGroup context) {
        this.context = context;
    }

    public ItemGroup getContext() {
        return this.context;
    }

    @NonNull
    protected String getVaultSecretKeyValue(String key) {
        String s = VaultHelper.getVaultSecretKey(this.path, key, this.prefixPath, this.namespace, this.engineVersion, (ItemGroup<Item>)this.context);
        if (s == null) {
            throw new VaultPluginException("Fetching from Vault failed for key '" + key + "'");
        }
        return s;
    }

    @NonNull
    protected Map<String, String> getVaultSecretValue() {
        Map<String, String> s = VaultHelper.getVaultSecret(this.path, this.prefixPath, this.namespace, this.engineVersion, (ItemGroup<Item>)this.context);
        if (s == null) {
            throw new VaultPluginException("Fetching from Vault failed for secret '" + this.path + "'");
        }
        return s;
    }

    public String getDisplayName() {
        return this.path;
    }
}

