/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.credentials;

import com.datapipe.jenkins.vault.credentials.AbstractVaultTokenCredential;
import com.datapipe.jenkins.vault.exception.VaultPluginException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.github.jopenlibs.vault.Vault;
import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class VaultTokenCredentialBinding
extends MultiBinding<AbstractVaultTokenCredential> {
    private static final String DEFAULT_VAULT_ADDR_VARIABLE_NAME = "VAULT_ADDR";
    private static final String DEFAULT_VAULT_TOKEN_VARIABLE_NAME = "VAULT_TOKEN";
    private static final String DEFAULT_VAULT_NAMESPACE_VARIABLE_NAME = "VAULT_NAMESPACE";
    @NonNull
    private final String addrVariable;
    private final String tokenVariable;
    private final String vaultAddr;
    private String vaultNamespace = "";
    private String namespaceVariable = "VAULT_NAMESPACE";

    @DataBoundConstructor
    public VaultTokenCredentialBinding(@Nullable String addrVariable, @Nullable String tokenVariable, String credentialsId, String vaultAddr) {
        super(credentialsId);
        this.vaultAddr = vaultAddr;
        this.addrVariable = StringUtils.defaultIfBlank((String)addrVariable, (String)DEFAULT_VAULT_ADDR_VARIABLE_NAME);
        this.tokenVariable = StringUtils.defaultIfBlank((String)tokenVariable, (String)DEFAULT_VAULT_TOKEN_VARIABLE_NAME);
    }

    @NonNull
    public String getVaultNamespace() {
        return this.vaultNamespace;
    }

    @DataBoundSetter
    public void setVaultNamespace(String vaultNamespace) {
        this.vaultNamespace = StringUtils.defaultIfBlank((String)vaultNamespace, (String)"");
    }

    @NonNull
    public String getNamespaceVariable() {
        return this.namespaceVariable;
    }

    @DataBoundSetter
    public void setNamespaceVariable(String namespaceVariable) {
        this.namespaceVariable = StringUtils.defaultIfBlank((String)namespaceVariable, (String)DEFAULT_VAULT_NAMESPACE_VARIABLE_NAME);
    }

    @NonNull
    public String getAddrVariable() {
        return this.addrVariable;
    }

    @NonNull
    public String getTokenVariable() {
        return this.tokenVariable;
    }

    @NonNull
    public String getVaultAddr() {
        return this.vaultAddr;
    }

    protected Class<AbstractVaultTokenCredential> type() {
        return AbstractVaultTokenCredential.class;
    }

    public MultiBinding.MultiEnvironment bind(@NonNull Run<?, ?> build, FilePath workspace, Launcher launcher, @NonNull TaskListener listener) throws IOException, InterruptedException {
        AbstractVaultTokenCredential credentials = (AbstractVaultTokenCredential)this.getCredentials(build);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(this.addrVariable, this.vaultAddr);
        m.put(this.namespaceVariable, this.vaultNamespace);
        String token = this.getToken(credentials);
        m.put(this.tokenVariable, StringUtils.defaultString((String)token));
        return new MultiBinding.MultiEnvironment(m);
    }

    private String getToken(AbstractVaultTokenCredential credentials) {
        try {
            VaultConfig config = new VaultConfig().address(this.vaultAddr);
            if (StringUtils.isNotEmpty((String)this.vaultNamespace)) {
                config.nameSpace(this.vaultNamespace);
            }
            config.build();
            return credentials.getToken(Vault.create((VaultConfig)config));
        }
        catch (VaultException e) {
            throw new VaultPluginException("could not log in into vault", e);
        }
    }

    public Set<String> variables() {
        return new HashSet<String>(Arrays.asList(this.addrVariable, this.namespaceVariable, this.tokenVariable));
    }

    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<AbstractVaultTokenCredential> {
        protected Class<AbstractVaultTokenCredential> type() {
            return AbstractVaultTokenCredential.class;
        }

        @NonNull
        public String getDisplayName() {
            return "HashiCorp Vault: Address, Namespace and Token";
        }
    }
}

