/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.credentials;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.datapipe.jenkins.vault.credentials.AbstractVaultTokenCredential;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.Secret;
import io.github.jopenlibs.vault.Vault;
import org.kohsuke.stapler.DataBoundConstructor;

public class VaultTokenCredential
extends AbstractVaultTokenCredential {
    private Secret token;

    @DataBoundConstructor
    public VaultTokenCredential(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @NonNull Secret token) {
        super(scope, id, description);
        this.token = token;
    }

    @NonNull
    public Secret getToken() {
        return this.token;
    }

    @Override
    public String getToken(Vault vault) {
        return Secret.toString((Secret)this.token);
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Vault Token Credential";
        }
    }
}

