/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.credentials;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.datapipe.jenkins.vault.credentials.AbstractAuthenticatingVaultTokenCredential;
import com.datapipe.jenkins.vault.exception.VaultPluginException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.Secret;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.api.Auth;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class VaultGithubTokenCredential
extends AbstractAuthenticatingVaultTokenCredential {
    @NonNull
    private final Secret accessToken;
    @NonNull
    private String mountPath = "github";

    @DataBoundConstructor
    public VaultGithubTokenCredential(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @NonNull Secret accessToken) {
        super(scope, id, description);
        this.accessToken = accessToken;
    }

    @NonNull
    public Secret getAccessToken() {
        return this.accessToken;
    }

    @NonNull
    public String getMountPath() {
        return this.mountPath;
    }

    @DataBoundSetter
    public void setMountPath(@NonNull String mountPath) {
        this.mountPath = StringUtils.defaultIfBlank((String)mountPath, (String)"github");
    }

    @Override
    public String getToken(Auth auth) {
        try {
            return auth.loginByGithub(Secret.toString((Secret)this.accessToken), this.mountPath).getAuthClientToken();
        }
        catch (VaultException e) {
            throw new VaultPluginException("could not log in into vault", e);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public static final String defaultPath = "github";

        @NonNull
        public String getDisplayName() {
            return "Vault Github Token Credential";
        }
    }
}

