/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.credentials;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.datapipe.jenkins.vault.credentials.AbstractAuthenticatingVaultTokenCredential;
import com.datapipe.jenkins.vault.exception.VaultPluginException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.api.Auth;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import org.kohsuke.stapler.DataBoundConstructor;

public class VaultGCPCredential
extends AbstractAuthenticatingVaultTokenCredential {
    @NonNull
    private final String role;
    @NonNull
    private final String audience;

    @DataBoundConstructor
    public VaultGCPCredential(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @NonNull String role, @NonNull String audience) {
        super(scope, id, description);
        this.role = role;
        this.audience = audience;
    }

    @NonNull
    public String getRole() {
        return this.role;
    }

    @NonNull
    public String getAudience() {
        return this.audience;
    }

    @Override
    public String getToken(Auth auth) {
        String jwt;
        try {
            jwt = this.retrieveGoogleJWT();
        }
        catch (IOException | URISyntaxException e) {
            throw new VaultPluginException("could not get JWT from GCP metadata", e);
        }
        try {
            return auth.loginByGCP(this.role, jwt).getAuthClientToken();
        }
        catch (VaultException e) {
            throw new VaultPluginException("could not log in into vault", e);
        }
    }

    private String retrieveGoogleJWT() throws URISyntaxException, IOException {
        String HTTP_SCHEME = "http";
        String NO_USER_INFO = null;
        String METADATA_HOST_ADDRESS = "metadata";
        int UNSPECIFIED_PORT = -1;
        String METADATA_PATH = "/computeMetadata/v1/instance/service-accounts/default/identity";
        String FRAGMENT = null;
        String query = "audience=" + this.audience + "&format=full";
        URL website = new URI("http", NO_USER_INFO, "metadata", -1, "/computeMetadata/v1/instance/service-accounts/default/identity", query, FRAGMENT).toURL();
        URLConnection connection = website.openConnection();
        HttpURLConnection httpConnection = VaultGCPCredential.safelyCastToHttpUrlConnection(connection);
        httpConnection.setRequestProperty("Metadata-Flavor", "Google");
        return VaultGCPCredential.download(httpConnection);
    }

    private static HttpURLConnection safelyCastToHttpUrlConnection(URLConnection connection) {
        if (connection instanceof HttpURLConnection) {
            return (HttpURLConnection)connection;
        }
        throw new RuntimeException("We do not have Http connection, but we used http schema");
    }

    private static String download(URLConnection connection) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            StringBuilder sb = new StringBuilder();
            in.lines().forEachOrdered(sb::append);
            String string = sb.toString();
            return string;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Vault GCP Credential";
        }
    }
}

