/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.credentials;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.properties.FolderCredentialsProvider;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.domains.DomainCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.datapipe.jenkins.vault.credentials.VaultCredential;
import com.datapipe.jenkins.vault.credentials.common.AbstractVaultBaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.springframework.security.core.Authentication;

@Extension(optional=true, ordinal=1.0)
public class VaultCredentialsProvider
extends CredentialsProvider {
    @NonNull
    public <C extends Credentials> List<C> getCredentialsInItemGroup(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        CredentialsMatcher matcher = type != VaultCredential.class ? CredentialsMatchers.instanceOf(AbstractVaultBaseStandardCredentials.class) : CredentialsMatchers.always();
        ArrayList creds = new ArrayList();
        if (ACL.SYSTEM2.equals((Object)authentication)) {
            ItemGroup g = itemGroup;
            while (g instanceof AbstractFolder) {
                FolderCredentialsProvider.FolderCredentialsProperty property = (FolderCredentialsProvider.FolderCredentialsProperty)((AbstractFolder)g).getProperties().get(FolderCredentialsProvider.FolderCredentialsProperty.class);
                if (property != null) {
                    List folderCreds = DomainCredentials.getCredentials((Map)property.getDomainCredentialsMap(), type, domainRequirements, (CredentialsMatcher)matcher);
                    if (type != VaultCredential.class) {
                        for (Credentials c : folderCreds) {
                            ((AbstractVaultBaseStandardCredentials)c).setContext(g);
                        }
                    }
                    creds.addAll(folderCreds);
                }
                g = ((AbstractFolder)g).getParent();
            }
            if (itemGroup == null || itemGroup == Jenkins.get()) {
                List globalCreds = DomainCredentials.getCredentials((Map)SystemCredentialsProvider.getInstance().getDomainCredentialsMap(), type, domainRequirements, (CredentialsMatcher)matcher);
                if (type != VaultCredential.class) {
                    for (Credentials c : globalCreds) {
                        ((AbstractVaultBaseStandardCredentials)c).setContext((ItemGroup)Jenkins.get());
                    }
                }
                creds.addAll(globalCreds);
            }
        }
        return creds;
    }
}

