/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.credentials;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.datapipe.jenkins.vault.credentials.AbstractAuthenticatingVaultTokenCredential;
import com.datapipe.jenkins.vault.exception.VaultPluginException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.util.Secret;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.api.Auth;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class VaultAppRoleCredential
extends AbstractAuthenticatingVaultTokenCredential {
    @NonNull
    private final Secret secretId;
    @NonNull
    private final String roleId;
    private String path;

    @DataBoundConstructor
    public VaultAppRoleCredential(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @NonNull String roleId, @NonNull Secret secretId, String path) {
        super(scope, id, description);
        this.secretId = secretId;
        this.roleId = roleId;
        path = Util.fixEmptyAndTrim((String)path);
        this.path = path == null ? "approle" : path;
    }

    @NonNull
    public String getRoleId() {
        return this.roleId;
    }

    @NonNull
    public Secret getSecretId() {
        return this.secretId;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public String getToken(Auth auth) {
        try {
            return auth.loginByAppRole(this.path, this.roleId, Secret.toString((Secret)this.secretId)).getAuthClientToken();
        }
        catch (VaultException e) {
            throw new VaultPluginException("could not log in into vault", e);
        }
    }

    protected Object readResolve() {
        if (StringUtils.isBlank((String)this.path)) {
            this.path = "approle";
        }
        return this;
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Vault App Role Credential";
        }
    }
}

