/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.credentials;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.datapipe.jenkins.vault.credentials.AbstractVaultTokenCredential;
import com.datapipe.jenkins.vault.exception.VaultPluginException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.github.jopenlibs.vault.Vault;
import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.api.Auth;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class AbstractVaultTokenCredentialWithExpiration
extends AbstractVaultTokenCredential {
    protected static final Logger LOGGER = Logger.getLogger(AbstractVaultTokenCredentialWithExpiration.class.getName());
    @CheckForNull
    private Boolean usePolicies;
    private transient Map<String, Calendar> tokenExpiryCache = new HashMap<String, Calendar>();
    private transient Map<String, String> tokenCache = new HashMap<String, String>();

    @CheckForNull
    public Boolean getUsePolicies() {
        return this.usePolicies;
    }

    @DataBoundSetter
    public void setUsePolicies(Boolean usePolicies) {
        this.usePolicies = usePolicies;
    }

    protected AbstractVaultTokenCredentialWithExpiration(CredentialsScope scope, String id, String description) {
        super(scope, id, description);
    }

    @Override
    protected abstract String getToken(Vault var1);

    protected Auth getVaultAuth(@NonNull Vault vault) {
        return vault.auth();
    }

    protected String getChildToken(Vault vault, List<String> policies) {
        if (this.usePolicies == null || !this.usePolicies.booleanValue() || policies == null || policies.isEmpty()) {
            return null;
        }
        Auth auth = this.getVaultAuth(vault);
        try {
            String ttl = String.format("%ds", this.getTokenTTL(vault));
            Auth.TokenRequest tokenRequest = new Auth.TokenRequest().polices(policies).ttl(ttl);
            LOGGER.log(Level.FINE, "Requesting child token with policies {0} and TTL {1}", new Object[]{policies, ttl});
            return auth.createToken(tokenRequest).getAuthClientToken();
        }
        catch (VaultException e) {
            throw new VaultPluginException("Could not retrieve token with policies from Vault", e);
        }
    }

    private String getCacheKey(List<String> policies) {
        if (policies == null || policies.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)",", policies);
    }

    @Override
    public Vault authorizeWithVault(VaultConfig config, List<String> policies) {
        if (this.tokenCache == null || this.tokenExpiryCache == null) {
            this.tokenCache = new HashMap<String, String>();
            this.tokenExpiryCache = new HashMap<String, Calendar>();
        }
        String cacheKey = this.getCacheKey(policies);
        Vault vault = this.getVault(config);
        if (this.tokenExpired(cacheKey)) {
            this.tokenCache.put(cacheKey, this.getToken(vault));
            config.token(this.tokenCache.get(cacheKey));
            String childToken = this.getChildToken(vault, policies);
            if (childToken != null) {
                this.tokenCache.put(cacheKey, childToken);
                config.token(childToken);
            }
            this.setTokenExpiry(vault, cacheKey);
        } else {
            config.token(this.tokenCache.get(cacheKey));
        }
        return vault;
    }

    protected Vault getVault(VaultConfig config) {
        return Vault.create((VaultConfig)config);
    }

    private long getTokenTTL(Vault vault) throws VaultException {
        return this.getVaultAuth(vault).lookupSelf().getTTL();
    }

    private void setTokenExpiry(Vault vault, String cacheKey) {
        int tokenTTL = 0;
        try {
            tokenTTL = (int)this.getTokenTTL(vault);
        }
        catch (VaultException e) {
            LOGGER.log(Level.WARNING, "Could not determine token expiration for policies '" + cacheKey + "'. Check if token is allowed to access auth/token/lookup-self. Assuming token TTL expired.", e);
        }
        Calendar expiry = Calendar.getInstance();
        expiry.add(13, tokenTTL);
        this.tokenExpiryCache.put(cacheKey, expiry);
    }

    private boolean tokenExpired(String cacheKey) {
        Calendar expiry = this.tokenExpiryCache.get(cacheKey);
        if (expiry == null) {
            return true;
        }
        boolean result = true;
        Calendar now = Calendar.getInstance();
        long timeDiffInMillis = now.getTimeInMillis() - expiry.getTimeInMillis();
        LOGGER.log(Level.FINE, "Expiration for " + cacheKey + " is " + String.valueOf(expiry) + ", diff: " + timeDiffInMillis);
        if (timeDiffInMillis < -10000L) {
            result = false;
            LOGGER.log(Level.FINE, "Auth token is still valid for policies '" + cacheKey + "'");
        } else {
            LOGGER.log(Level.FINE, "Auth token has to be re-issued for policies '" + cacheKey + "' (" + timeDiffInMillis + "ms difference)");
        }
        return result;
    }
}

