/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.credentials;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.datapipe.jenkins.vault.credentials.AbstractVaultTokenCredentialWithExpiration;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import io.github.jopenlibs.vault.Vault;
import io.github.jopenlibs.vault.api.Auth;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class AbstractAuthenticatingVaultTokenCredential
extends AbstractVaultTokenCredentialWithExpiration {
    @CheckForNull
    private String namespace;

    protected AbstractAuthenticatingVaultTokenCredential(CredentialsScope scope, String id, String description) {
        super(scope, id, description);
    }

    @CheckForNull
    public String getNamespace() {
        return this.namespace;
    }

    @DataBoundSetter
    public void setNamespace(String namespace) {
        this.namespace = Util.fixEmptyAndTrim((String)namespace);
    }

    @Override
    protected Auth getVaultAuth(@NonNull Vault vault) {
        Auth auth = vault.auth();
        if (this.namespace != null) {
            if (!this.namespace.trim().equals("/")) {
                auth.withNameSpace(this.namespace);
            } else {
                auth.withNameSpace(null);
            }
        }
        return auth;
    }

    @Override
    protected final String getToken(Vault vault) {
        return this.getToken(this.getVaultAuth(vault));
    }

    protected abstract String getToken(@NonNull Auth var1);
}

