/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.configuration;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.datapipe.jenkins.vault.credentials.VaultCredential;
import com.datapipe.jenkins.vault.exception.VaultPluginException;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import io.github.jopenlibs.vault.SslConfig;
import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class VaultConfiguration
extends AbstractDescribableImpl<VaultConfiguration>
implements Serializable {
    private static final int RETRY_INTERVAL_MILLISECONDS = 1000;
    private static final int DEFAULT_TIMEOUT = 30;
    private String vaultUrl;
    private String vaultCredentialId;
    private VaultCredential vaultCredential;
    private Boolean failIfNotFound = true;
    private Boolean skipSslVerification = false;
    private Integer engineVersion;
    private String vaultNamespace;
    private String prefixPath;
    private String policies;
    private Boolean disableChildPoliciesOverride;
    private Integer timeout = 30;

    @DataBoundConstructor
    public VaultConfiguration() {
    }

    @Deprecated
    public VaultConfiguration(String vaultUrl, String vaultCredentialId, boolean failIfNotFound) {
        this.setVaultUrl(vaultUrl);
        this.setVaultCredentialId(vaultCredentialId);
        this.setFailIfNotFound(failIfNotFound);
    }

    public VaultConfiguration(VaultConfiguration toCopy) {
        this.vaultUrl = toCopy.getVaultUrl();
        this.vaultCredentialId = toCopy.getVaultCredentialId();
        this.vaultCredential = toCopy.getVaultCredential();
        this.failIfNotFound = toCopy.failIfNotFound;
        this.skipSslVerification = toCopy.skipSslVerification;
        this.engineVersion = toCopy.engineVersion;
        this.vaultNamespace = toCopy.vaultNamespace;
        this.prefixPath = toCopy.prefixPath;
        this.policies = toCopy.policies;
        this.disableChildPoliciesOverride = toCopy.disableChildPoliciesOverride;
        this.timeout = toCopy.timeout;
    }

    public VaultConfiguration mergeWithParent(VaultConfiguration parent) {
        if (parent == null) {
            return this;
        }
        VaultConfiguration result = new VaultConfiguration(this);
        if (StringUtils.isBlank((String)result.getVaultCredentialId())) {
            result.setVaultCredentialId(parent.getVaultCredentialId());
        }
        if (result.vaultCredential == null) {
            result.setVaultCredential(parent.getVaultCredential());
        }
        if (StringUtils.isBlank((String)result.getVaultUrl())) {
            result.setVaultUrl(parent.getVaultUrl());
        }
        if (result.engineVersion == null) {
            result.setEngineVersion(parent.getEngineVersion());
        }
        if (StringUtils.isBlank((String)result.getVaultNamespace())) {
            result.setVaultNamespace(parent.getVaultNamespace());
        }
        if (StringUtils.isBlank((String)result.getPrefixPath())) {
            result.setPrefixPath(parent.getPrefixPath());
        }
        if (StringUtils.isBlank((String)result.getPolicies()) || parent.getDisableChildPoliciesOverride() != null && parent.getDisableChildPoliciesOverride().booleanValue()) {
            result.setPolicies(parent.getPolicies());
        }
        if (result.timeout == null) {
            result.setTimeout(parent.getTimeout());
        }
        if (result.failIfNotFound == null) {
            result.setFailIfNotFound(parent.failIfNotFound);
        }
        if (result.skipSslVerification == null) {
            result.setSkipSslVerification(parent.skipSslVerification);
        }
        return result;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    public String getVaultCredentialId() {
        return this.vaultCredentialId;
    }

    public VaultCredential getVaultCredential() {
        return this.vaultCredential;
    }

    @DataBoundSetter
    public void setVaultUrl(String vaultUrl) {
        this.vaultUrl = this.normalizeUrl(Util.fixEmptyAndTrim((String)vaultUrl));
    }

    @DataBoundSetter
    public void setVaultCredentialId(String vaultCredentialId) {
        this.vaultCredentialId = Util.fixEmptyAndTrim((String)vaultCredentialId);
    }

    @DataBoundSetter
    public void setVaultCredential(VaultCredential vaultCredential) {
        this.vaultCredential = vaultCredential;
    }

    public Boolean getFailIfNotFound() {
        return this.failIfNotFound;
    }

    @DataBoundSetter
    public void setFailIfNotFound(Boolean failIfNotFound) {
        this.failIfNotFound = failIfNotFound;
    }

    public Boolean getSkipSslVerification() {
        return this.skipSslVerification;
    }

    @DataBoundSetter
    public void setSkipSslVerification(Boolean skipSslVerification) {
        this.skipSslVerification = skipSslVerification;
    }

    public Integer getEngineVersion() {
        return this.engineVersion;
    }

    @DataBoundSetter
    public void setEngineVersion(Integer engineVersion) {
        this.engineVersion = engineVersion;
    }

    public String getVaultNamespace() {
        return this.vaultNamespace;
    }

    @DataBoundSetter
    public void setVaultNamespace(String vaultNamespace) {
        this.vaultNamespace = Util.fixEmptyAndTrim((String)vaultNamespace);
    }

    public String getPrefixPath() {
        return this.prefixPath;
    }

    @DataBoundSetter
    public void setPrefixPath(String prefixPath) {
        this.prefixPath = Util.fixEmptyAndTrim((String)prefixPath);
    }

    public String getPolicies() {
        return this.policies;
    }

    @DataBoundSetter
    public void setPolicies(String policies) {
        this.policies = Util.fixEmptyAndTrim((String)policies);
    }

    public Boolean getDisableChildPoliciesOverride() {
        return this.disableChildPoliciesOverride;
    }

    @DataBoundSetter
    public void setDisableChildPoliciesOverride(Boolean disableChildPoliciesOverride) {
        this.disableChildPoliciesOverride = disableChildPoliciesOverride;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    @DataBoundSetter
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public int getMaxRetries() {
        int to = null != this.getTimeout() ? this.getTimeout() : 30;
        return (int)((double)to * 1000.0 / 1000.0);
    }

    public int getRetryIntervalMilliseconds() {
        return 1000;
    }

    @NonNull
    public VaultConfig getVaultConfig() {
        VaultConfig vaultConfig = new VaultConfig();
        vaultConfig.address(this.getVaultUrl());
        vaultConfig.engineVersion(this.getEngineVersion());
        try {
            if (this.getSkipSslVerification().booleanValue()) {
                vaultConfig.sslConfig(new SslConfig().verify(Boolean.valueOf(false)).build());
            }
            if (StringUtils.isNotEmpty((String)this.getVaultNamespace())) {
                vaultConfig.nameSpace(this.getVaultNamespace());
            }
            if (StringUtils.isNotEmpty((String)this.getPrefixPath())) {
                vaultConfig.prefixPath(this.getPrefixPath());
            }
        }
        catch (VaultException e) {
            throw new VaultPluginException("Could not set up VaultConfig.", e);
        }
        return vaultConfig;
    }

    public VaultConfiguration fixDefaults() {
        if (this.getEngineVersion() == null) {
            this.setEngineVersion(2);
        }
        if (this.getSkipSslVerification() == null) {
            this.setSkipSslVerification(false);
        }
        if (this.getFailIfNotFound() == null) {
            this.setFailIfNotFound(true);
        }
        return this;
    }

    @Restricted(value={NoExternalUse.class})
    public static ListBoxModel engineVersions(Item context) {
        ListBoxModel options = new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option("2", "2"), new ListBoxModel.Option("1", "1")});
        if (context != null) {
            ListBoxModel.Option option = new ListBoxModel.Option("Default", "");
            options.add(0, (Object)option);
        }
        return options;
    }

    private String normalizeUrl(String url) {
        if (url == null) {
            return null;
        }
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<VaultConfiguration> {
        public static final boolean DEFAULT_FAIL_NOT_FOUND = true;
        public static final boolean DEFAULT_SKIP_SSL_VERIFICATION = false;
        public static final int DEFAULT_ENGINE_VERSION = 2;

        @NonNull
        public String getDisplayName() {
            return "Vault Configuration";
        }

        public ListBoxModel doFillVaultCredentialIdItems(@AncestorInPath Item item, @QueryParameter String uri) {
            List domainRequirements = URIRequirementBuilder.fromUri((String)uri).build();
            return new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM2, item, VaultCredential.class, domainRequirements);
        }

        public ListBoxModel doFillEngineVersionItems(@AncestorInPath Item context) {
            return VaultConfiguration.engineVersions(context);
        }
    }
}

