/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault.configuration;

import com.datapipe.jenkins.vault.configuration.VaultConfigResolver;
import com.datapipe.jenkins.vault.configuration.VaultConfiguration;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
@Symbol(value={"hashicorpVault"})
public class GlobalVaultConfiguration
extends GlobalConfiguration {
    private VaultConfiguration configuration;

    public static GlobalVaultConfiguration get() {
        return (GlobalVaultConfiguration)((Object)ExtensionList.lookupSingleton(GlobalVaultConfiguration.class));
    }

    public GlobalVaultConfiguration() {
        this.load();
    }

    public VaultConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        return true;
    }

    @DataBoundSetter
    public void setConfiguration(VaultConfiguration configuration) {
        this.configuration = configuration;
        if (this.configuration != null && this.configuration.getEngineVersion() == null) {
            this.configuration.setEngineVersion(2);
        }
        this.save();
    }

    protected Object readResolve() {
        if (this.configuration != null && this.configuration.getEngineVersion() == null) {
            this.configuration.setEngineVersion(2);
        }
        return this;
    }

    @Extension(ordinal=0.0)
    public static class ForJob
    extends VaultConfigResolver {
        @Override
        @NonNull
        public VaultConfiguration forJob(@NonNull Item job) {
            return this.getVaultConfig(job.getParent());
        }

        public VaultConfiguration getVaultConfig(@NonNull ItemGroup itemGroup) {
            return GlobalVaultConfiguration.get().getConfiguration();
        }
    }
}

