/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault;

import com.datapipe.jenkins.vault.VaultAccessor;
import com.datapipe.jenkins.vault.configuration.VaultConfiguration;
import com.datapipe.jenkins.vault.credentials.VaultCredential;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.github.jopenlibs.vault.VaultConfig;
import java.io.IOException;
import java.util.List;
import jenkins.tasks.SimpleBuildWrapper;

public class VaultDisposer
extends SimpleBuildWrapper.Disposer {
    private final List<String> leaseIds;
    private final VaultConfiguration vaultConfiguration;
    private final VaultCredential vaultCredential;

    public VaultDisposer(VaultConfiguration vaultConfiguration, VaultCredential vaultCredential, List<String> leaseIds) {
        this.vaultConfiguration = vaultConfiguration;
        this.vaultCredential = vaultCredential;
        this.leaseIds = leaseIds;
    }

    public void tearDown(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        VaultConfig vaultConfig = new VaultConfig().address(this.vaultConfiguration.getVaultUrl());
        VaultAccessor vaultAccessor = new VaultAccessor(vaultConfig, this.vaultCredential).init();
        for (String leaseId : this.leaseIds) {
            if (leaseId == null || leaseId.isEmpty()) continue;
            vaultAccessor.revoke(leaseId);
        }
    }
}

