/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault;

import com.datapipe.jenkins.vault.VaultAccessor;
import com.datapipe.jenkins.vault.configuration.VaultConfigResolver;
import com.datapipe.jenkins.vault.configuration.VaultConfiguration;
import com.datapipe.jenkins.vault.exception.VaultPluginException;
import com.datapipe.jenkins.vault.log.MaskingConsoleLogFilter;
import com.datapipe.jenkins.vault.model.VaultSecret;
import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Launcher;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jenkins.tasks.SimpleBuildWrapper;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class VaultBuildWrapper
extends SimpleBuildWrapper {
    private VaultConfiguration configuration;
    private List<VaultSecret> vaultSecrets;
    private List<String> valuesToMask = new ArrayList<String>();
    private transient VaultAccessor vaultAccessor = new VaultAccessor();
    protected transient PrintStream logger;

    @DataBoundConstructor
    public VaultBuildWrapper(@CheckForNull List<VaultSecret> vaultSecrets) {
        this.vaultSecrets = vaultSecrets;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) {
        this.logger = listener.getLogger();
        this.pullAndMergeConfiguration(build);
        if (null != this.vaultSecrets && !this.vaultSecrets.isEmpty()) {
            this.provideEnvironmentVariablesFromVault(context, build, initialEnvironment);
        }
    }

    public List<VaultSecret> getVaultSecrets() {
        return this.vaultSecrets;
    }

    @DataBoundSetter
    public void setConfiguration(VaultConfiguration configuration) {
        this.configuration = configuration;
    }

    public VaultConfiguration getConfiguration() {
        return this.configuration;
    }

    @VisibleForTesting
    public void setVaultAccessor(VaultAccessor vaultAccessor) {
        this.vaultAccessor = vaultAccessor;
    }

    protected void provideEnvironmentVariablesFromVault(SimpleBuildWrapper.Context context, Run build, EnvVars envVars) {
        Map<String, String> overrides = VaultAccessor.retrieveVaultSecrets(build, this.logger, envVars, this.vaultAccessor, this.getConfiguration(), this.getVaultSecrets());
        for (Map.Entry<String, String> secret : overrides.entrySet()) {
            this.valuesToMask.add(secret.getValue());
            context.env(secret.getKey(), secret.getValue());
        }
    }

    private void pullAndMergeConfiguration(Run<?, ?> build) {
        for (VaultConfigResolver resolver : ExtensionList.lookup(VaultConfigResolver.class)) {
            if (this.configuration != null) {
                this.configuration = this.configuration.mergeWithParent(resolver.forJob((Item)build.getParent()));
                continue;
            }
            this.configuration = resolver.forJob((Item)build.getParent());
        }
        if (this.configuration == null) {
            throw new VaultPluginException("No configuration found - please configure the VaultPlugin.");
        }
        this.configuration.fixDefaults();
    }

    public ConsoleLogFilter createLoggerDecorator(@NonNull Run<?, ?> build) {
        return new MaskingConsoleLogFilter(build.getCharset().name(), this.valuesToMask);
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public DescriptorImpl() {
            super(VaultBuildWrapper.class);
            this.load();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return "Vault Plugin";
        }
    }
}

