/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault;

import com.datapipe.jenkins.vault.VaultAccessor;
import com.datapipe.jenkins.vault.configuration.VaultConfiguration;
import com.datapipe.jenkins.vault.log.MaskingConsoleLogFilter;
import com.datapipe.jenkins.vault.model.VaultSecret;
import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.console.ConsoleLogFilter;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.Secret;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.GeneralNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class VaultBindingStep
extends Step {
    private VaultConfiguration configuration;
    private List<VaultSecret> vaultSecrets;

    @DataBoundConstructor
    public VaultBindingStep(@CheckForNull List<VaultSecret> vaultSecrets) {
        this.vaultSecrets = vaultSecrets;
    }

    public List<VaultSecret> getVaultSecrets() {
        return this.vaultSecrets;
    }

    @DataBoundSetter
    public void setConfiguration(VaultConfiguration configuration) {
        this.configuration = configuration;
    }

    public VaultConfiguration getConfiguration() {
        return this.configuration;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    protected static class Execution
    extends GeneralNonBlockingStepExecution {
        private static final long serialVersionUID = 1L;
        private transient VaultBindingStep step;
        private transient VaultAccessor vaultAccessor;

        public Execution(VaultBindingStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        @VisibleForTesting
        public void setVaultAccessor(VaultAccessor vaultAccessor) {
            this.vaultAccessor = vaultAccessor;
        }

        public boolean start() throws Exception {
            this.run(this::doStart);
            return false;
        }

        private void doStart() throws Exception {
            Run run = (Run)this.getContext().get(Run.class);
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            EnvVars envVars = (EnvVars)this.getContext().get(EnvVars.class);
            Map<String, String> overrides = VaultAccessor.retrieveVaultSecrets(run, listener.getLogger(), envVars, this.vaultAccessor, this.step.getConfiguration(), this.step.getVaultSecrets());
            ArrayList<String> secretValues = new ArrayList<String>(overrides.values());
            this.getContext().newBodyInvoker().withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)new Overrider(overrides))).withContext((Object)BodyInvoker.mergeConsoleLogFilters((ConsoleLogFilter)((ConsoleLogFilter)this.getContext().get(ConsoleLogFilter.class)), (ConsoleLogFilter)new MaskingConsoleLogFilter(run.getCharset().name(), secretValues))).withCallback((BodyExecutionCallback)new Callback()).start();
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(TaskListener.class, Run.class, EnvVars.class);
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public String getFunctionName() {
            return "withVault";
        }

        @NonNull
        public String getDisplayName() {
            return "Vault Plugin";
        }
    }

    private static class Callback
    extends BodyExecutionCallback.TailCall {
        private Callback() {
        }

        protected void finished(StepContext context) throws Exception {
        }
    }

    private static final class Overrider
    extends EnvironmentExpander {
        private static final long serialVersionUID = 1L;
        private final Map<String, Secret> overrides = new HashMap<String, Secret>();

        Overrider(Map<String, String> overrides) {
            for (Map.Entry<String, String> override : overrides.entrySet()) {
                this.overrides.put(override.getKey(), Secret.fromString((String)override.getValue()));
            }
        }

        public void expand(EnvVars env) throws IOException, InterruptedException {
            for (Map.Entry<String, Secret> override : this.overrides.entrySet()) {
                env.override(override.getKey(), override.getValue().getPlainText());
            }
        }

        public Set<String> getSensitiveVariables() {
            return Collections.unmodifiableSet(this.overrides.keySet());
        }
    }
}

