/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gravatar;

import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.model.User;
import hudson.tasks.UserAvatarResolver;
import java.util.logging.Logger;
import org.jenkinsci.plugins.gravatar.cache.GravatarImageResolutionCache;
import org.jenkinsci.plugins.gravatar.cache.GravatarImageResolutionCacheInstance;
import org.jenkinsci.plugins.gravatar.model.GravatarUrlCreator;

@Extension
public class UserGravatarResolver
extends UserAvatarResolver {
    private static final Logger LOG = Logger.getLogger(UserGravatarResolver.class.getName());

    public String findAvatarFor(User user, int width, int height) {
        if (this.isGravatarUser(user)) {
            LOG.finest("Resolving gravatar url for user " + user.getId() + " in size " + width + "x" + height);
            GravatarUrlCreator urlCreator = this.urlCreatorFor(user);
            return urlCreator.buildUrlForSize(width);
        }
        return null;
    }

    @VisibleForTesting
    protected GravatarUrlCreator urlCreatorFor(User user) {
        return (GravatarUrlCreator)this.cache().urlCreatorFor(user).get();
    }

    boolean isGravatarUser(User user) {
        return this.cache().hasGravatarCreator(user);
    }

    @VisibleForTesting
    GravatarImageResolutionCache cache() {
        return GravatarImageResolutionCacheInstance.INSTANCE;
    }
}

