/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gravatar.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import hudson.model.User;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jenkinsci.plugins.gravatar.cache.GravatarImageResolutionCacheLoader;
import org.jenkinsci.plugins.gravatar.model.GravatarUrlCreator;
import org.jenkinsci.plugins.gravatar.model.GravatarUser;

public class GravatarImageResolutionLoadingCache {
    private static final Logger LOG = Logger.getLogger(GravatarImageResolutionLoadingCache.class.getName());
    private final LoadingCache<GravatarUser, Optional<GravatarUrlCreator>> cache;

    GravatarImageResolutionLoadingCache() {
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(2).refreshAfterWrite(30L, TimeUnit.MINUTES).initialCapacity(User.getAll().size()).build(this.createUrlForUser());
    }

    @VisibleForTesting
    protected GravatarImageResolutionLoadingCache(LoadingCache<GravatarUser, Optional<GravatarUrlCreator>> cache) {
        this.cache = cache;
    }

    private CacheLoader<GravatarUser, Optional<GravatarUrlCreator>> createUrlForUser() {
        return new GravatarImageResolutionCacheLoader();
    }

    public Optional<GravatarUrlCreator> urlCreatorFor(User user) {
        try {
            return (Optional)this.cache.get((Object)this.keyOf(user));
        }
        catch (ExecutionException e) {
            return Optional.absent();
        }
    }

    public void loadIfUnknown(User user) {
        GravatarUser gravatarUser = this.keyOf(user);
        if (!this.isKnown(gravatarUser)) {
            try {
                this.cache.get((Object)gravatarUser);
            }
            catch (ExecutionException e) {
                LOG.info("Failed to load gravatar for user " + String.valueOf(gravatarUser));
            }
        }
    }

    boolean isKnown(GravatarUser user) {
        return this.cache.asMap().containsKey(user);
    }

    public boolean hasGravatarCreator(User user) {
        return this.hasGravatarCreator(this.keyOf(user));
    }

    private boolean hasGravatarCreator(GravatarUser user) {
        return this.isKnown(user) && ((Optional)this.cache.getUnchecked((Object)user)).isPresent();
    }

    private GravatarUser keyOf(User user) {
        return GravatarUser.gravatarUser(user);
    }
}

