/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.injection.token;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.plugins.gradle.injection.DevelocityAccessCredentials;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortLivedTokenClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShortLivedTokenClient.class);
    private static final RequestBody EMPTY_BODY = RequestBody.create((byte[])new byte[0]);
    private static final int MAX_RETRIES = 3;
    private static final Duration RETRY_INTERVAL = Duration.ofSeconds(1L);
    private final OkHttpClient httpClient;

    public ShortLivedTokenClient(boolean allowUntrusted) {
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder().callTimeout(10L, TimeUnit.SECONDS);
        if (allowUntrusted) {
            builder.hostnameVerifier((hostname, session) -> true);
            try {
                TrustManager[] allTrustingTrustManager = ShortLivedTokenClient.createAllTrustingTrustManager();
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, allTrustingTrustManager, null);
                builder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)allTrustingTrustManager[0]);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        this.httpClient = builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public Optional<DevelocityAccessCredentials.HostnameAccessKey> get(String server, DevelocityAccessCredentials.HostnameAccessKey accessKey, @Nullable Integer expiry) {
        String url = ShortLivedTokenClient.normalize(server) + "api/auth/token";
        if (expiry != null) {
            url = url + "?expiresInHours=" + expiry;
        }
        Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + accessKey.getKey()).addHeader("Content-Type", "application/json").post(EMPTY_BODY).build();
        int tryCount = 0;
        Integer errorCode = null;
        while (true) {
            if (tryCount >= 3) {
                LOGGER.warn("Develocity short lived token request failed {} with status code {}", (Object)url, errorCode);
                return Optional.empty();
            }
            try {
                Response response = this.httpClient.newCall(request).execute();
                try {
                    if (response.code() == 200 && response.body() != null) {
                        Optional<DevelocityAccessCredentials.HostnameAccessKey> optional = Optional.of(DevelocityAccessCredentials.HostnameAccessKey.of(accessKey.getHostname(), response.body().string()));
                        return optional;
                    }
                    if (response.code() == 401) {
                        LOGGER.warn("Develocity short lived token request failed {} with status code 401", (Object)url);
                        Optional<DevelocityAccessCredentials.HostnameAccessKey> optional = Optional.empty();
                        return optional;
                    }
                    ++tryCount;
                    errorCode = response.code();
                    Thread.sleep(RETRY_INTERVAL.toMillis());
                    continue;
                }
                finally {
                    if (response == null) continue;
                    response.close();
                    continue;
                }
            }
            catch (IOException e) {
                LOGGER.warn("Short lived token request failed {}", (Object)url, (Object)e);
                return Optional.empty();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private static String normalize(String server) {
        if (server.endsWith("/")) {
            return server;
        }
        return server + "/";
    }

    private static TrustManager[] createAllTrustingTrustManager() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }
}

