/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.injection.extension;

import hudson.plugins.gradle.injection.MavenExtension;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class ExtensionClient {
    private final OkHttpClient httpClient = new OkHttpClient().newBuilder().readTimeout(60L, TimeUnit.SECONDS).build();

    public void downloadExtension(URI downloadUrl, @Nullable MavenExtension.RepositoryCredentials repositoryCredentials, OutputStream outputStream) throws IOException {
        Request.Builder requestBuilder = new Request.Builder().url(downloadUrl.toURL());
        if (repositoryCredentials != null) {
            String basicCredentials = Credentials.basic((String)repositoryCredentials.username(), (String)repositoryCredentials.password());
            requestBuilder.addHeader("Authorization", basicCredentials);
        }
        try (Response response = this.httpClient.newCall(requestBuilder.build()).execute();){
            ResponseBody responseBody = response.body();
            if (!response.isSuccessful() || responseBody == null) {
                throw new IOException("Could not download the extension from " + String.valueOf(downloadUrl));
            }
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(responseBody.byteStream());){
                bufferedInputStream.transferTo(outputStream);
            }
        }
    }
}

